/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model.changestream;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.changestream.TruncatedArray;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.NonNull;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.codecs.pojo.annotations.BsonCreator;
import org.apache.flink.mongodb.shaded.org.bson.codecs.pojo.annotations.BsonProperty;

public final class UpdateDescription {
    private final List<String> removedFields;
    private final BsonDocument updatedFields;
    private final List<TruncatedArray> truncatedArrays;

    public UpdateDescription(@Nullable List<String> removedFields, @Nullable BsonDocument updatedFields) {
        this(removedFields, updatedFields, null);
    }

    @BsonCreator
    public UpdateDescription(@Nullable @BsonProperty(value="removedFields") List<String> removedFields, @Nullable @BsonProperty(value="updatedFields") BsonDocument updatedFields, @Nullable @BsonProperty(value="truncatedArrays") List<TruncatedArray> truncatedArrays) {
        this.removedFields = removedFields;
        this.updatedFields = updatedFields;
        this.truncatedArrays = truncatedArrays == null ? Collections.emptyList() : truncatedArrays;
    }

    @Nullable
    public List<String> getRemovedFields() {
        return this.removedFields;
    }

    @Nullable
    public BsonDocument getUpdatedFields() {
        return this.updatedFields;
    }

    @NonNull
    public List<TruncatedArray> getTruncatedArrays() {
        return this.truncatedArrays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDescription that = (UpdateDescription)o;
        return Objects.equals(this.removedFields, that.removedFields) && Objects.equals(this.updatedFields, that.updatedFields) && Objects.equals(this.truncatedArrays, that.truncatedArrays);
    }

    public int hashCode() {
        return Objects.hash(this.removedFields, this.updatedFields, this.truncatedArrays);
    }

    public String toString() {
        return "UpdateDescription{removedFields=" + this.removedFields + ", updatedFields=" + this.updatedFields + ", truncatedArrays=" + this.truncatedArrays + "}";
    }
}

