/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.model;

import java.util.concurrent.TimeUnit;
import org.apache.flink.mongodb.shaded.com.mongodb.CreateIndexCommitQuorum;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

public class CreateIndexOptions {
    private long maxTimeMS;
    private CreateIndexCommitQuorum commitQuorum;

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public CreateIndexOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Nullable
    public CreateIndexCommitQuorum getCommitQuorum() {
        return this.commitQuorum;
    }

    public CreateIndexOptions commitQuorum(CreateIndexCommitQuorum commitQuorum) {
        this.commitQuorum = commitQuorum;
        return this;
    }

    public String toString() {
        return "CreateIndexOptions{maxTimeMS=" + this.maxTimeMS + ", commitQuorum=" + this.commitQuorum + '}';
    }
}

