/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb.client.internal;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.flink.mongodb.shaded.com.mongodb.AutoEncryptionSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.ClientEncryptionSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoClientSettings;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoClient;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoClients;
import org.apache.flink.mongodb.shaded.com.mongodb.client.internal.CollectionInfoRetriever;
import org.apache.flink.mongodb.shaded.com.mongodb.client.internal.CommandMarker;
import org.apache.flink.mongodb.shaded.com.mongodb.client.internal.Crypt;
import org.apache.flink.mongodb.shaded.com.mongodb.client.internal.KeyManagementService;
import org.apache.flink.mongodb.shaded.com.mongodb.client.internal.KeyRetriever;
import org.apache.flink.mongodb.shaded.com.mongodb.client.internal.MongoClientImpl;
import org.apache.flink.mongodb.shaded.com.mongodb.crypt.capi.MongoCrypt;
import org.apache.flink.mongodb.shaded.com.mongodb.crypt.capi.MongoCryptOptions;
import org.apache.flink.mongodb.shaded.com.mongodb.crypt.capi.MongoCrypts;
import org.apache.flink.mongodb.shaded.com.mongodb.internal.capi.MongoCryptHelper;

public final class Crypts {
    public static Crypt createCrypt(MongoClientImpl client, AutoEncryptionSettings settings) {
        MongoClient internalClient = null;
        MongoClientSettings keyVaultMongoClientSettings = settings.getKeyVaultMongoClientSettings();
        if (keyVaultMongoClientSettings == null || !settings.isBypassAutoEncryption()) {
            MongoClientSettings mongoClientSettings = MongoClientSettings.builder(client.getSettings()).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            internalClient = MongoClients.create(mongoClientSettings);
        }
        MongoClient keyVaultClient = keyVaultMongoClientSettings == null ? internalClient : MongoClients.create(keyVaultMongoClientSettings);
        MongoCrypt mongoCrypt = MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings));
        return new Crypt(mongoCrypt, Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers(), settings.isBypassAutoEncryption(), settings.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(internalClient), new CommandMarker(mongoCrypt, settings), internalClient);
    }

    static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings settings) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings)), Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers());
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap) {
        return new KeyManagementService(kmsProviderSslContextMap, 10000);
    }

    private Crypts() {
    }
}

