/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.mongodb.shaded.com.mongodb.annotations.Immutable;
import org.apache.flink.mongodb.shaded.com.mongodb.assertions.Assertions;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;
import org.apache.flink.mongodb.shaded.org.bson.BsonBoolean;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;

@Immutable
public class WriteConcern
implements Serializable {
    private static final long serialVersionUID = 1884671104750417011L;
    private static final Map<String, WriteConcern> NAMED_CONCERNS;
    private final Object w;
    private final Integer wTimeoutMS;
    private final Boolean journal;
    public static final WriteConcern ACKNOWLEDGED;
    public static final WriteConcern W1;
    public static final WriteConcern W2;
    public static final WriteConcern W3;
    public static final WriteConcern UNACKNOWLEDGED;
    public static final WriteConcern JOURNALED;
    public static final WriteConcern MAJORITY;

    public WriteConcern(int w) {
        this(w, null, null);
    }

    public WriteConcern(String w) {
        this(w, null, null);
        Assertions.notNull("w", w);
    }

    public WriteConcern(int w, int wTimeoutMS) {
        this(w, wTimeoutMS, null);
    }

    private WriteConcern(@Nullable Object w, @Nullable Integer wTimeoutMS, @Nullable Boolean journal) {
        if (w instanceof Integer) {
            Assertions.isTrueArgument("w >= 0", (Integer)w >= 0);
            if ((Integer)w == 0) {
                Assertions.isTrueArgument("journal is false when w is 0", journal == null || journal == false);
            }
        } else if (w != null) {
            Assertions.isTrueArgument("w must be String or int", w instanceof String);
        }
        Assertions.isTrueArgument("wtimeout >= 0", wTimeoutMS == null || wTimeoutMS >= 0);
        this.w = w;
        this.wTimeoutMS = wTimeoutMS;
        this.journal = journal;
    }

    @Nullable
    public Object getWObject() {
        return this.w;
    }

    public int getW() {
        Assertions.isTrue("w is an Integer", this.w != null && this.w instanceof Integer);
        return (Integer)this.w;
    }

    public String getWString() {
        Assertions.isTrue("w is a String", this.w != null && this.w instanceof String);
        return (String)this.w;
    }

    @Nullable
    public Integer getWTimeout(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return this.wTimeoutMS == null ? null : Integer.valueOf((int)timeUnit.convert(this.wTimeoutMS.intValue(), TimeUnit.MILLISECONDS));
    }

    @Nullable
    public Boolean getJournal() {
        return this.journal;
    }

    public boolean isServerDefault() {
        return this.equals(ACKNOWLEDGED);
    }

    public BsonDocument asDocument() {
        BsonDocument document = new BsonDocument();
        this.addW(document);
        this.addWTimeout(document);
        this.addJ(document);
        return document;
    }

    public boolean isAcknowledged() {
        if (this.w instanceof Integer) {
            return (Integer)this.w > 0 || this.journal != null && this.journal != false;
        }
        return true;
    }

    public static WriteConcern valueOf(String name) {
        return NAMED_CONCERNS.get(name.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteConcern that = (WriteConcern)o;
        if (this.w != null ? !this.w.equals(that.w) : that.w != null) {
            return false;
        }
        if (this.wTimeoutMS != null ? !this.wTimeoutMS.equals(that.wTimeoutMS) : that.wTimeoutMS != null) {
            return false;
        }
        return !(this.journal != null ? !this.journal.equals(that.journal) : that.journal != null);
    }

    public int hashCode() {
        int result = this.w != null ? this.w.hashCode() : 0;
        result = 31 * result + (this.wTimeoutMS != null ? this.wTimeoutMS.hashCode() : 0);
        result = 31 * result + (this.journal != null ? this.journal.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WriteConcern{w=" + this.w + ", wTimeout=" + this.wTimeoutMS + " ms, journal=" + this.journal + "}";
    }

    public WriteConcern withW(int w) {
        return new WriteConcern(w, this.wTimeoutMS, this.journal);
    }

    public WriteConcern withW(String w) {
        Assertions.notNull("w", w);
        return new WriteConcern(w, this.wTimeoutMS, this.journal);
    }

    public WriteConcern withJournal(@Nullable Boolean journal) {
        return new WriteConcern(this.w, this.wTimeoutMS, journal);
    }

    public WriteConcern withWTimeout(long wTimeout, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        long newWTimeOutMS = TimeUnit.MILLISECONDS.convert(wTimeout, timeUnit);
        Assertions.isTrueArgument("wTimeout >= 0", wTimeout >= 0L);
        Assertions.isTrueArgument("wTimeout <= 2147483647 ms", newWTimeOutMS <= Integer.MAX_VALUE);
        return new WriteConcern(this.w, (int)newWTimeOutMS, this.journal);
    }

    private void addW(BsonDocument document) {
        if (this.w instanceof String) {
            document.put("w", new BsonString((String)this.w));
        } else if (this.w instanceof Integer) {
            document.put("w", new BsonInt32((Integer)this.w));
        }
    }

    private void addJ(BsonDocument document) {
        if (this.journal != null) {
            document.put("j", BsonBoolean.valueOf(this.journal));
        }
    }

    private void addWTimeout(BsonDocument document) {
        if (this.wTimeoutMS != null) {
            document.put("wtimeout", new BsonInt32(this.wTimeoutMS));
        }
    }

    static {
        ACKNOWLEDGED = new WriteConcern(null, null, null);
        W1 = new WriteConcern(1);
        W2 = new WriteConcern(2);
        W3 = new WriteConcern(3);
        UNACKNOWLEDGED = new WriteConcern(0);
        JOURNALED = ACKNOWLEDGED.withJournal(true);
        MAJORITY = new WriteConcern("majority");
        NAMED_CONCERNS = new HashMap<String, WriteConcern>();
        for (Field f : WriteConcern.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().equals(WriteConcern.class)) continue;
            String key = f.getName().toLowerCase();
            try {
                NAMED_CONCERNS.put(key, (WriteConcern)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

