/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mongodb.shaded.com.mongodb;

import org.apache.flink.mongodb.shaded.com.mongodb.MongoCommandException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoServerException;
import org.apache.flink.mongodb.shaded.com.mongodb.ServerAddress;
import org.apache.flink.mongodb.shaded.com.mongodb.lang.Nullable;

public class MongoQueryException
extends MongoServerException {
    private static final long serialVersionUID = -5113350133297015801L;
    private final String errorMessage;

    public MongoQueryException(ServerAddress address, int errorCode, String errorMessage) {
        super(errorCode, String.format("Query failed with error code %d and error message '%s' on server %s", errorCode, errorMessage, address), address);
        this.errorMessage = errorMessage;
    }

    public MongoQueryException(ServerAddress address, int errorCode, @Nullable String errorCodeName, String errorMessage) {
        super(errorCode, errorCodeName, String.format("Query failed with error code %d with name '%s' and error message '%s' on server %s", errorCode, errorCodeName, errorMessage, address), address);
        this.errorMessage = errorMessage;
    }

    public MongoQueryException(MongoCommandException commandException) {
        this(commandException.getServerAddress(), commandException.getErrorCode(), commandException.getErrorCodeName(), commandException.getErrorMessage());
        this.addLabels(commandException.getErrorLabels());
    }

    public int getErrorCode() {
        return this.getCode();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

