/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.split;

import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.mongodb.source.split.MongoSourceSplit;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;

@PublicEvolving
public class MongoScanSourceSplit
extends MongoSourceSplit {
    private static final long serialVersionUID = 1L;
    private final String database;
    private final String collection;
    private final BsonDocument min;
    private final BsonDocument max;
    private final BsonDocument hint;
    private final int offset;

    public MongoScanSourceSplit(String splitId, String database, String collection, BsonDocument min, BsonDocument max, BsonDocument hint) {
        this(splitId, database, collection, min, max, hint, 0);
    }

    public MongoScanSourceSplit(String splitId, String database, String collection, BsonDocument min, BsonDocument max, BsonDocument hint, int offset) {
        super(splitId);
        this.database = database;
        this.collection = collection;
        this.min = min;
        this.max = max;
        this.hint = hint;
        this.offset = offset;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public BsonDocument getMin() {
        return this.min;
    }

    public BsonDocument getMax() {
        return this.max;
    }

    public BsonDocument getHint() {
        return this.hint;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MongoScanSourceSplit split = (MongoScanSourceSplit)o;
        return Objects.equals(this.database, split.database) && Objects.equals(this.collection, split.collection) && Objects.equals(this.min, split.min) && Objects.equals(this.max, split.max) && Objects.equals(this.hint, split.hint) && this.offset == split.offset;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.database, this.collection, this.min, this.max, this.hint, this.offset);
    }

    public String toString() {
        return "MongoScanSourceSplit { splitId=" + this.splitId + ", database=" + this.database + ", collection=" + this.collection + ", min=" + this.min + ", max=" + this.max + ", hint=" + this.hint + ", offset=" + this.offset + " }";
    }
}

