/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.enumerator.splitter;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.mongodb.common.utils.MongoConstants;
import org.apache.flink.connector.mongodb.common.utils.MongoUtils;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSingleSplitter;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSplitContext;
import org.apache.flink.connector.mongodb.source.split.MongoScanSourceSplit;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoClient;
import org.apache.flink.mongodb.shaded.org.bson.BsonArray;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoSplitVectorSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(MongoSplitVectorSplitter.class);

    private MongoSplitVectorSplitter() {
    }

    public static Collection<MongoScanSourceSplit> split(MongoSplitContext splitContext) {
        BsonDocument splitResult;
        if (splitContext.isSharded()) {
            throw new FlinkRuntimeException("splitVector does not apply to sharded collections.");
        }
        MongoClient mongoClient = splitContext.getMongoClient();
        MongoNamespace namespace = splitContext.getMongoNamespace();
        MongoReadOptions readOptions = splitContext.getReadOptions();
        MemorySize chunkSize = readOptions.getPartitionSize();
        int maxChunkSizeMB = Math.max(chunkSize.getMebiBytes(), 1);
        BsonDocument keyPattern = new BsonDocument("_id", new BsonInt32(1));
        try {
            splitResult = MongoUtils.splitVector(mongoClient, namespace, keyPattern, maxChunkSizeMB);
        }
        catch (MongoException e) {
            LOG.error("Execute splitVector command failed : {}", (Object)e.getMessage());
            throw new FlinkRuntimeException((Throwable)e);
        }
        BsonArray splitKeys = splitResult.getArray("splitKeys");
        if (CollectionUtils.isEmpty((Collection)splitKeys)) {
            return MongoSingleSplitter.split(splitContext);
        }
        splitKeys.add(new BsonDocument("_id", MongoConstants.BSON_MAX_KEY));
        ArrayList<MongoScanSourceSplit> sourceSplits = new ArrayList<MongoScanSourceSplit>(splitKeys.size());
        BsonValue lowerValue = MongoConstants.BSON_MIN_KEY;
        for (int i = 0; i < splitKeys.size(); ++i) {
            BsonValue splitKeyValue = splitKeys.get(i).asDocument().get("_id");
            sourceSplits.add(new MongoScanSourceSplit(String.format("%s_%d", namespace, i), namespace.getDatabaseName(), namespace.getCollectionName(), new BsonDocument("_id", lowerValue), new BsonDocument("_id", splitKeyValue), MongoConstants.ID_HINT));
            lowerValue = splitKeyValue;
        }
        return sourceSplits;
    }
}

