/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.enumerator.splitter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.common.utils.MongoUtils;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSplitContext;
import org.apache.flink.connector.mongodb.source.split.MongoScanSourceSplit;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoException;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoClient;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoShardedSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(MongoShardedSplitter.class);

    private MongoShardedSplitter() {
    }

    public static Collection<MongoScanSourceSplit> split(MongoSplitContext splitContext) {
        List<BsonDocument> chunks;
        Optional<BsonDocument> collectionMetadata;
        MongoNamespace namespace = splitContext.getMongoNamespace();
        MongoClient mongoClient = splitContext.getMongoClient();
        try {
            collectionMetadata = MongoUtils.readCollectionMetadata(mongoClient, namespace);
            if (!collectionMetadata.isPresent()) {
                LOG.error("Do sharded split failed, collection {} does not appear to be sharded.", (Object)namespace);
                throw new FlinkRuntimeException(String.format("Do sharded split failed, %s is not a sharded collection.", namespace));
            }
            if (MongoUtils.isShardedCollectionDropped(collectionMetadata.get())) {
                LOG.error("Do sharded split failed, collection {} was dropped.", (Object)namespace);
                throw new FlinkRuntimeException(String.format("Do sharded split failed, %s was dropped.", namespace));
            }
            chunks = MongoUtils.readChunks(mongoClient, collectionMetadata.get());
            if (chunks.isEmpty()) {
                LOG.error("Do sharded split failed, chunks of {} is empty.", (Object)namespace);
                throw new FlinkRuntimeException(String.format("Do sharded split failed, chunks of %s is empty.", namespace));
            }
        }
        catch (MongoException e) {
            LOG.error("Read chunks from {} failed with error message: {}", (Object)namespace, (Object)e.getMessage());
            throw new FlinkRuntimeException((Throwable)e);
        }
        ArrayList<MongoScanSourceSplit> sourceSplits = new ArrayList<MongoScanSourceSplit>(chunks.size());
        for (int i = 0; i < chunks.size(); ++i) {
            BsonDocument chunk = chunks.get(i);
            sourceSplits.add(new MongoScanSourceSplit(String.format("%s_%d", namespace, i), namespace.getDatabaseName(), namespace.getCollectionName(), chunk.getDocument("min"), chunk.getDocument("max"), collectionMetadata.get().getDocument("key")));
        }
        return sourceSplits;
    }
}

