/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.source.MongoSource;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.PartitionStrategy;
import org.apache.flink.connector.mongodb.source.reader.deserializer.MongoDeserializationSchema;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.Filters;
import org.apache.flink.mongodb.shaded.org.bson.conversions.Bson;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MongoSourceBuilder<OUT> {
    private final MongoConnectionOptions.MongoConnectionOptionsBuilder connectionOptionsBuilder;
    private final MongoReadOptions.MongoReadOptionsBuilder readOptionsBuilder;
    private List<String> projectedFields;
    private Bson filter = Filters.empty();
    private int limit = -1;
    private MongoDeserializationSchema<OUT> deserializationSchema;

    MongoSourceBuilder() {
        this.connectionOptionsBuilder = MongoConnectionOptions.builder();
        this.readOptionsBuilder = MongoReadOptions.builder();
    }

    public MongoSourceBuilder<OUT> setUri(String uri) {
        this.connectionOptionsBuilder.setUri(uri);
        return this;
    }

    public MongoSourceBuilder<OUT> setDatabase(String database) {
        this.connectionOptionsBuilder.setDatabase(database);
        return this;
    }

    public MongoSourceBuilder<OUT> setCollection(String collection) {
        this.connectionOptionsBuilder.setCollection(collection);
        return this;
    }

    public MongoSourceBuilder<OUT> setFetchSize(int fetchSize) {
        this.readOptionsBuilder.setFetchSize(fetchSize);
        return this;
    }

    public MongoSourceBuilder<OUT> setNoCursorTimeout(boolean noCursorTimeout) {
        this.readOptionsBuilder.setNoCursorTimeout(noCursorTimeout);
        return this;
    }

    public MongoSourceBuilder<OUT> setPartitionStrategy(PartitionStrategy partitionStrategy) {
        this.readOptionsBuilder.setPartitionStrategy(partitionStrategy);
        return this;
    }

    public MongoSourceBuilder<OUT> setPartitionSize(MemorySize partitionSize) {
        this.readOptionsBuilder.setPartitionSize(partitionSize);
        return this;
    }

    public MongoSourceBuilder<OUT> setSamplesPerPartition(int samplesPerPartition) {
        this.readOptionsBuilder.setSamplesPerPartition(samplesPerPartition);
        return this;
    }

    public MongoSourceBuilder<OUT> setLimit(int limit) {
        Preconditions.checkArgument((limit == -1 || limit > 0 ? 1 : 0) != 0, (Object)"The limit must be larger than 0");
        this.limit = limit;
        return this;
    }

    public MongoSourceBuilder<OUT> setFilter(Bson filter) {
        this.filter = (Bson)Preconditions.checkNotNull((Object)filter, (String)"The filter must not be null");
        return this;
    }

    public MongoSourceBuilder<OUT> setProjectedFields(String ... projectedFields) {
        Preconditions.checkNotNull((Object)projectedFields, (String)"The projected fields must be supplied");
        return this.setProjectedFields(Arrays.asList(projectedFields));
    }

    public MongoSourceBuilder<OUT> setProjectedFields(List<String> projectedFields) {
        Preconditions.checkArgument((!CollectionUtil.isNullOrEmpty(projectedFields) ? 1 : 0) != 0, (Object)"At least one projected field to be supplied");
        this.projectedFields = projectedFields;
        return this;
    }

    public MongoSourceBuilder<OUT> setDeserializationSchema(MongoDeserializationSchema<OUT> deserializationSchema) {
        Preconditions.checkNotNull(deserializationSchema, (String)"The deserialization schema must not be null");
        this.deserializationSchema = deserializationSchema;
        return this;
    }

    public MongoSource<OUT> build() {
        Preconditions.checkNotNull(this.deserializationSchema, (String)"The deserialization schema must be supplied");
        return new MongoSource<OUT>(this.connectionOptionsBuilder.build(), this.readOptionsBuilder.build(), this.projectedFields, this.filter, this.limit, this.deserializationSchema);
    }
}

