/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.time;

import com.mongodb.kafka.connect.util.Assertions;
import com.mongodb.kafka.connect.util.time.Timer;
import com.mongodb.lang.Nullable;
import java.time.Duration;
import java.util.function.Consumer;

public final class InnerOuterTimer {
    private final Consumer<Duration> innerConsumer;
    private final Consumer<Duration> outerConsumer;
    private final Timer timer;
    @Nullable
    private Duration tPreviousEndTask;

    private InnerOuterTimer(Timer timer, Consumer<Duration> innerConsumer, Consumer<Duration> outerConsumer) {
        this.innerConsumer = innerConsumer;
        this.outerConsumer = outerConsumer;
        this.timer = timer;
    }

    public static InnerOuterTimer start(Consumer<Duration> innerConsumer, Consumer<Duration> outerConsumer) {
        return new InnerOuterTimer(Timer.start(), innerConsumer, outerConsumer);
    }

    public InnerTimer sampleOuter() {
        Duration tBeginTask = this.timer.getElapsedTime();
        if (this.tPreviousEndTask != null) {
            Duration outer = tBeginTask.minus(this.tPreviousEndTask);
            Assertions.assertFalse(outer.isNegative());
            this.outerConsumer.accept(outer);
        }
        return () -> {
            Duration tEndTask = this.timer.getElapsedTime();
            Duration inner = tEndTask.minus(tBeginTask);
            Assertions.assertFalse(inner.isNegative());
            this.innerConsumer.accept(inner);
            this.tPreviousEndTask = tEndTask;
        };
    }

    public static interface InnerTimer
    extends AutoCloseable {
        @Override
        public void close();
    }
}

