/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.producer;

import com.mongodb.kafka.connect.source.producer.SchemaAndValueProducer;
import com.mongodb.kafka.connect.source.schema.AvroSchema;
import com.mongodb.kafka.connect.source.schema.BsonValueToSchemaAndValue;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import org.bson.BsonDocument;
import org.bson.json.JsonWriterSettings;

final class AvroSchemaAndValueProducer
implements SchemaAndValueProducer {
    private final Schema schema;
    private final BsonValueToSchemaAndValue bsonValueToSchemaAndValue;

    AvroSchemaAndValueProducer(String jsonSchema, JsonWriterSettings jsonWriterSettings) {
        this.schema = AvroSchema.fromJson(jsonSchema);
        this.bsonValueToSchemaAndValue = new BsonValueToSchemaAndValue(jsonWriterSettings);
    }

    @Override
    public SchemaAndValue get(BsonDocument changeStreamDocument) {
        return this.bsonValueToSchemaAndValue.toSchemaAndValue(this.schema, changeStreamDocument);
    }
}

