/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.converter.types.sink.bson.logical;

import com.mongodb.kafka.connect.sink.converter.types.sink.bson.SinkFieldConverter;
import java.math.BigDecimal;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonValue;
import org.bson.types.Decimal128;

public class DecimalFieldConverter
extends SinkFieldConverter {
    private Format format;

    public DecimalFieldConverter() {
        super(Decimal.schema(0));
        this.format = Format.DECIMAL128;
    }

    public DecimalFieldConverter(Format format) {
        super(Decimal.schema(0));
        this.format = format;
    }

    @Override
    public BsonValue toBson(Object data) {
        if (data instanceof BigDecimal) {
            if (this.format.equals((Object)Format.DECIMAL128)) {
                return new BsonDecimal128(new Decimal128((BigDecimal)data));
            }
            if (this.format.equals((Object)Format.LEGACYDOUBLE)) {
                return new BsonDouble(((BigDecimal)data).doubleValue());
            }
        }
        throw new DataException("Decimal conversion not possible when data is of type " + data.getClass().getName() + " and format is " + (Object)((Object)this.format));
    }

    public static enum Format {
        DECIMAL128,
        LEGACYDOUBLE;

    }
}

