/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.mongodb.operations;

import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.mongodb.operations.OperationHelper;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Update
implements CdcOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Update.class);

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument changeStreamDocument = doc.getValueDoc().orElseThrow(() -> new DataException("Error: value doc must not be missing for update operation"));
        BsonDocument documentKey = OperationHelper.getDocumentKey(changeStreamDocument);
        if (OperationHelper.hasFullDocument(changeStreamDocument)) {
            LOGGER.debug("The full Document available, creating a replace operation.");
            return new ReplaceOneModel<BsonDocument>(documentKey, OperationHelper.getFullDocument(changeStreamDocument));
        }
        LOGGER.debug("No full document field available, creating update operation.");
        return new UpdateOneModel<BsonDocument>((Bson)documentKey, OperationHelper.getUpdateDocument(changeStreamDocument));
    }
}

