/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.kinesis.FixedKinesisPartitioner;
import org.apache.flink.streaming.connectors.kinesis.KinesisPartitioner;
import org.apache.flink.streaming.connectors.kinesis.RandomKinesisPartitioner;
import org.apache.flink.streaming.connectors.kinesis.table.KinesisConnectorOptions;
import org.apache.flink.streaming.connectors.kinesis.table.RowDataFieldsKinesisPartitioner;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;

@Internal
class KinesisConnectorOptionsUtil {
    public static final String SINK_PARTITIONER_VALUE_FIXED = "fixed";
    public static final String SINK_PARTITIONER_VALUE_RANDOM = "random";
    public static final String AWS_PROPERTIES_PREFIX = "aws.";
    public static final String CONSUMER_PREFIX = "scan.";
    public static final String PRODUCER_PREFIX = "sink.producer.";
    public static final String[] NON_VALIDATED_PREFIXES = new String[]{"aws.", "scan.", "sink.producer."};
    public static final Set<String> TABLE_LEVEL_OPTIONS = new HashSet<String>(Arrays.asList(KinesisConnectorOptions.STREAM.key(), FactoryUtil.FORMAT.key(), KinesisConnectorOptions.SINK_PARTITIONER.key(), KinesisConnectorOptions.SINK_PARTITIONER_FIELD_DELIMITER.key()));

    public static Properties getConsumerProperties(Map<String, String> tableOptions) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : tableOptions.entrySet()) {
            String sourceKey = entry.getKey();
            String sourceVal = entry.getValue();
            if (TABLE_LEVEL_OPTIONS.contains(sourceKey)) continue;
            if (sourceKey.startsWith(AWS_PROPERTIES_PREFIX)) {
                properties.put(KinesisConnectorOptionsUtil.translateAwsKey(sourceKey), sourceVal);
                continue;
            }
            if (!sourceKey.startsWith(CONSUMER_PREFIX)) continue;
            properties.put(KinesisConnectorOptionsUtil.translateConsumerKey(sourceKey), sourceVal);
        }
        return properties;
    }

    public static Properties getProducerProperties(Map<String, String> tableOptions) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : tableOptions.entrySet()) {
            String sourceKey = entry.getKey();
            String sourceVal = entry.getValue();
            if (TABLE_LEVEL_OPTIONS.contains(sourceKey)) continue;
            if (sourceKey.startsWith(AWS_PROPERTIES_PREFIX)) {
                properties.put(KinesisConnectorOptionsUtil.translateAwsKey(sourceKey), sourceVal);
                continue;
            }
            if (!sourceKey.startsWith(PRODUCER_PREFIX)) continue;
            properties.put(KinesisConnectorOptionsUtil.translateProducerKey(sourceKey), sourceVal);
        }
        return properties;
    }

    private static String translateAwsKey(String key) {
        if (!key.endsWith("credentials.provider")) {
            return key.replace("credentials.", "credentials.provider.");
        }
        return key;
    }

    private static String translateConsumerKey(String key) {
        String result = "flink." + key.substring(CONSUMER_PREFIX.length());
        if (result.endsWith("initpos-timestamp-format")) {
            return result.replace("initpos-timestamp-format", "initpos.timestamp.format");
        }
        if (result.endsWith("initpos-timestamp")) {
            return result.replace("initpos-timestamp", "initpos.timestamp");
        }
        return result;
    }

    private static String translateProducerKey(String key) {
        String suffix = key.substring(PRODUCER_PREFIX.length());
        return Arrays.stream(suffix.split("-")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(""));
    }

    public static KinesisPartitioner<RowData> getKinesisPartitioner(ReadableConfig tableOptions, RowType physicalType, List<String> partitionKeys, ClassLoader classLoader) {
        if (!partitionKeys.isEmpty()) {
            String delimiter = (String)tableOptions.get(KinesisConnectorOptions.SINK_PARTITIONER_FIELD_DELIMITER);
            return new RowDataFieldsKinesisPartitioner(physicalType, partitionKeys, delimiter);
        }
        if (!tableOptions.getOptional(KinesisConnectorOptions.SINK_PARTITIONER).isPresent()) {
            return new RandomKinesisPartitioner<RowData>();
        }
        String partitioner = (String)tableOptions.getOptional(KinesisConnectorOptions.SINK_PARTITIONER).get();
        if (SINK_PARTITIONER_VALUE_FIXED.equals(partitioner)) {
            return new FixedKinesisPartitioner<RowData>();
        }
        if (SINK_PARTITIONER_VALUE_RANDOM.equals(partitioner)) {
            return new RandomKinesisPartitioner<RowData>();
        }
        return KinesisConnectorOptionsUtil.initializePartitioner(partitioner, classLoader);
    }

    private static <T> KinesisPartitioner<T> initializePartitioner(String name, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(name, true, classLoader);
            if (!KinesisPartitioner.class.isAssignableFrom(clazz)) {
                throw new ValidationException(String.format("Partitioner class '%s' should have %s in its parents chain", name, KinesisPartitioner.class.getName()));
            }
            KinesisPartitioner partitioner = (KinesisPartitioner)InstantiationUtil.instantiate((String)name, KinesisPartitioner.class, (ClassLoader)classLoader);
            return partitioner;
        }
        catch (ClassNotFoundException | FlinkException e) {
            throw new ValidationException(String.format("Could not find and instantiate partitioner class '%s'", name), e);
        }
    }

    private KinesisConnectorOptionsUtil() {
    }
}

