/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.streaming.connectors.kinesis.KinesisPartitioner;

@PublicEvolving
public class KinesisConnectorOptions {
    public static final ConfigOption<String> STREAM = ConfigOptions.key((String)"stream").stringType().noDefaultValue().withDescription("Name of the Kinesis stream backing this table.");
    public static final ConfigOption<String> SINK_PARTITIONER = ConfigOptions.key((String)"sink.partitioner").stringType().noDefaultValue().withDescription(Description.builder().text("Optional output partitioning from Flink's partitions into Kinesis shards. Sinks that write to tables defined with the %s clause always use a field-based partitioner and cannot define this option.", new InlineElement[]{TextElement.code((String)"PARTITION BY")}).linebreak().text("Valid enumerations are").list(new InlineElement[]{TextElement.text((String)"random (use a random partition key)"), TextElement.text((String)"fixed (each Flink partition ends up in at most one Kinesis shard)"), TextElement.text((String)"custom class name (use a custom %s subclass)", (InlineElement[])new InlineElement[]{TextElement.text((String)KinesisPartitioner.class.getName())})}).build());
    public static final ConfigOption<String> SINK_PARTITIONER_FIELD_DELIMITER = ConfigOptions.key((String)"sink.partitioner-field-delimiter").stringType().defaultValue((Object)"|").withDescription(Description.builder().text("Optional field delimiter for fields-based partitioner derived from a %s clause", new InlineElement[]{TextElement.code((String)"PARTITION BY")}).build());

    private KinesisConnectorOptions() {
    }
}

