/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.exception.AwsServiceException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricPublisher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.NoOpMetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.ExceptionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.ExpiredTokenException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetAccessKeyInfoResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.IdpRejectedClaimException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.InvalidAuthorizationMessageException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.InvalidIdentityTokenException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.RegionDisabledException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.StsException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.transform.AssumeRoleRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.transform.AssumeRoleWithSamlRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.transform.GetAccessKeyInfoRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.transform.GetCallerIdentityRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.transform.GetFederationTokenRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.transform.GetSessionTokenRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkInternalApi
final class DefaultStsAsyncClient
implements StsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultStsAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultStsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    @Override
    public final String serviceName() {
        return "sts";
    }

    @Override
    public CompletableFuture<AssumeRoleResponse> assumeRole(AssumeRoleRequest assumeRoleRequest) {
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(this.clientConfiguration, assumeRoleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRole");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRole").withMarshaller(new AssumeRoleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(assumeRoleRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<AssumeRoleWithSamlResponse> assumeRoleWithSAML(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) {
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(this.clientConfiguration, assumeRoleWithSamlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRoleWithSAML");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleWithSamlResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleWithSAML").withMarshaller(new AssumeRoleWithSamlRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(assumeRoleWithSamlRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<AssumeRoleWithWebIdentityResponse> assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(this.clientConfiguration, assumeRoleWithWebIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeRoleWithWebIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleWithWebIdentityResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleWithWebIdentity").withMarshaller(new AssumeRoleWithWebIdentityRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(assumeRoleWithWebIdentityRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DecodeAuthorizationMessageResponse> decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) {
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(this.clientConfiguration, decodeAuthorizationMessageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecodeAuthorizationMessage");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DecodeAuthorizationMessageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecodeAuthorizationMessage").withMarshaller(new DecodeAuthorizationMessageRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(decodeAuthorizationMessageRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetAccessKeyInfoResponse> getAccessKeyInfo(GetAccessKeyInfoRequest getAccessKeyInfoRequest) {
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessKeyInfoRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessKeyInfo");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetAccessKeyInfoResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessKeyInfo").withMarshaller(new GetAccessKeyInfoRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(getAccessKeyInfoRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetCallerIdentityResponse> getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) {
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCallerIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCallerIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCallerIdentityResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCallerIdentity").withMarshaller(new GetCallerIdentityRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(getCallerIdentityRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetFederationTokenResponse> getFederationToken(GetFederationTokenRequest getFederationTokenRequest) {
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFederationTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFederationToken");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetFederationTokenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFederationToken").withMarshaller(new GetFederationTokenRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(getFederationTokenRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetSessionTokenResponse> getSessionToken(GetSessionTokenRequest getSessionTokenRequest) {
        List<MetricPublisher> metricPublishers = DefaultStsAsyncClient.resolveMetricPublishers(this.clientConfiguration, getSessionTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "STS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionToken");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSessionTokenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSessionToken").withMarshaller(new GetSessionTokenRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput(getSessionTokenRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return ((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)((AwsQueryProtocolFactory.Builder)AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAuthorizationMessageException").exceptionBuilderSupplier(InvalidAuthorizationMessageException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredTokenException").exceptionBuilderSupplier(ExpiredTokenException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("PackedPolicyTooLarge").exceptionBuilderSupplier(PackedPolicyTooLargeException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("RegionDisabledException").exceptionBuilderSupplier(RegionDisabledException::builder).httpStatusCode(403).build())).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedPolicyDocument").exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("IDPRejectedClaim").exceptionBuilderSupplier(IdpRejectedClaimException::builder).httpStatusCode(403).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIdentityToken").exceptionBuilderSupplier(InvalidIdentityTokenException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("IDPCommunicationError").exceptionBuilderSupplier(IdpCommunicationErrorException::builder).httpStatusCode(400).build())).clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(StsException::builder)).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }
}

