/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ScalingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateShardCountRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, UpdateShardCountRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(UpdateShardCountRequest.getter(UpdateShardCountRequest::streamName)).setter(UpdateShardCountRequest.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<Integer> TARGET_SHARD_COUNT_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("TargetShardCount").getter(UpdateShardCountRequest.getter(UpdateShardCountRequest::targetShardCount)).setter(UpdateShardCountRequest.setter(Builder::targetShardCount)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetShardCount").build()).build();
    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ScalingType").getter(UpdateShardCountRequest.getter(UpdateShardCountRequest::scalingTypeAsString)).setter(UpdateShardCountRequest.setter(Builder::scalingType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, TARGET_SHARD_COUNT_FIELD, SCALING_TYPE_FIELD));
    private final String streamName;
    private final Integer targetShardCount;
    private final String scalingType;

    private UpdateShardCountRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.targetShardCount = builder.targetShardCount;
        this.scalingType = builder.scalingType;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final Integer targetShardCount() {
        return this.targetShardCount;
    }

    public final ScalingType scalingType() {
        return ScalingType.fromValue(this.scalingType);
    }

    public final String scalingTypeAsString() {
        return this.scalingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountRequest)) {
            return false;
        }
        UpdateShardCountRequest other = (UpdateShardCountRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.targetShardCount(), other.targetShardCount()) && Objects.equals(this.scalingTypeAsString(), other.scalingTypeAsString());
    }

    public final String toString() {
        return ToString.builder("UpdateShardCountRequest").add("StreamName", this.streamName()).add("TargetShardCount", this.targetShardCount()).add("ScalingType", this.scalingTypeAsString()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "TargetShardCount": {
                return Optional.ofNullable(clazz.cast(this.targetShardCount()));
            }
            case "ScalingType": {
                return Optional.ofNullable(clazz.cast(this.scalingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateShardCountRequest, T> g) {
        return obj -> g.apply((UpdateShardCountRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer targetShardCount;
        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.targetShardCount(model.targetShardCount);
            this.scalingType(model.scalingType);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Integer getTargetShardCount() {
            return this.targetShardCount;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final String getScalingType() {
            return this.scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(ScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateShardCountRequest build() {
            return new UpdateShardCountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateShardCountRequest> {
        public Builder streamName(String var1);

        public Builder targetShardCount(Integer var1);

        public Builder scalingType(String var1);

        public Builder scalingType(ScalingType var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

