/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamMode {
    PROVISIONED("PROVISIONED"),
    ON_DEMAND("ON_DEMAND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamMode> VALUE_MAP;
    private final String value;

    private StreamMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamMode> knownValues() {
        EnumSet<StreamMode> knownValues = EnumSet.allOf(StreamMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamMode.class, StreamMode::toString);
    }
}

