/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.marshall;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.MapTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.marshall.QueryMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.marshall.QueryMarshallerContext;

@SdkInternalApi
public class MapQueryMarshaller
implements QueryMarshaller<Map<String, ?>> {
    @Override
    public void marshall(QueryMarshallerContext context, String path, Map<String, ?> val, SdkField<Map<String, ?>> sdkField) {
        MapTrait mapTrait = sdkField.getTrait(MapTrait.class);
        AtomicInteger entryNum = new AtomicInteger(1);
        val.forEach((key, value) -> {
            String mapKeyPath = MapQueryMarshaller.resolveMapPath(path, mapTrait, entryNum, mapTrait.keyLocationName());
            context.request().putRawQueryParameter(mapKeyPath, (String)key);
            String mapValuePath = MapQueryMarshaller.resolveMapPath(path, mapTrait, entryNum, mapTrait.valueLocationName());
            QueryMarshaller<Object> marshaller = context.marshallerRegistry().getMarshaller(mapTrait.valueFieldInfo().marshallingType(), val);
            marshaller.marshall(context, mapValuePath, value, mapTrait.valueFieldInfo());
            entryNum.incrementAndGet();
        });
    }

    private static String resolveMapPath(String path, MapTrait mapTrait, AtomicInteger entryNum, String s) {
        return mapTrait.isFlattened() ? String.format("%s.%d.%s", path, entryNum.get(), s) : String.format("%s.entry.%d.%s", path, entryNum.get(), s);
    }
}

