/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.async;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.flink.kinesis.shaded.org.reactivestreams.Subscriber;
import org.apache.flink.kinesis.shaded.org.reactivestreams.Subscription;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.AsyncRequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class ByteArrayAsyncRequestBody
implements AsyncRequestBody {
    private static final Logger log = Logger.loggerFor(ByteArrayAsyncRequestBody.class);
    private final byte[] bytes;
    private final String mimetype;

    public ByteArrayAsyncRequestBody(byte[] bytes, String mimetype) {
        this.bytes = (byte[])bytes.clone();
        this.mimetype = mimetype;
    }

    @Override
    public Optional<Long> contentLength() {
        return Optional.of(Long.valueOf(this.bytes.length));
    }

    @Override
    public String contentType() {
        return this.mimetype;
    }

    @Override
    public void subscribe(final Subscriber<? super ByteBuffer> s) {
        if (s == null) {
            throw new NullPointerException("Subscription MUST NOT be null.");
        }
        try {
            s.onSubscribe(new Subscription(){
                private boolean done = false;

                @Override
                public void request(long n) {
                    if (this.done) {
                        return;
                    }
                    if (n > 0L) {
                        this.done = true;
                        s.onNext(ByteBuffer.wrap(ByteArrayAsyncRequestBody.this.bytes));
                        s.onComplete();
                    } else {
                        s.onError(new IllegalArgumentException("\u00a73.9: non-positive requests are not allowed!"));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.done) {
                            this.done = true;
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            log.error(() -> s + " violated the Reactive Streams rule 2.13 by throwing an exception from onSubscribe.", ex);
        }
    }
}

