/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;

@SdkPublicApi
public final class ExecutionAttribute<T> {
    private static final ConcurrentMap<String, ExecutionAttribute<?>> NAME_HISTORY = new ConcurrentHashMap();
    private final String name;

    public ExecutionAttribute(String name) {
        this.name = name;
        this.ensureUnique();
    }

    private void ensureUnique() {
        ExecutionAttribute prev = NAME_HISTORY.putIfAbsent(this.name, this);
        if (prev != null) {
            throw new IllegalArgumentException(String.format("No duplicate ExecutionAttribute names allowed but both ExecutionAttributes %s and %s have the same name: %s. ExecutionAttributes should be referenced from a shared static constant to protect against erroneous or unexpected collisions.", Integer.toHexString(System.identityHashCode(prev)), Integer.toHexString(System.identityHashCode(this)), this.name));
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionAttribute that = (ExecutionAttribute)o;
        return that.name.equals(this.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

