/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class FileTransformerConfiguration
implements ToCopyableBuilder<Builder, FileTransformerConfiguration> {
    private final FileWriteOption fileWriteOption;
    private final FailureBehavior failureBehavior;

    private FileTransformerConfiguration(DefaultBuilder builder) {
        this.fileWriteOption = Validate.paramNotNull(builder.fileWriteOption, "fileWriteOption");
        this.failureBehavior = Validate.paramNotNull(builder.failureBehavior, "failureBehavior");
    }

    public FileWriteOption fileWriteOption() {
        return this.fileWriteOption;
    }

    public FailureBehavior failureBehavior() {
        return this.failureBehavior;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static FileTransformerConfiguration defaultCreateNew() {
        return (FileTransformerConfiguration)FileTransformerConfiguration.builder().fileWriteOption(FileWriteOption.CREATE_NEW).failureBehavior(FailureBehavior.DELETE).build();
    }

    public static FileTransformerConfiguration defaultCreateOrReplaceExisting() {
        return (FileTransformerConfiguration)FileTransformerConfiguration.builder().fileWriteOption(FileWriteOption.CREATE_OR_REPLACE_EXISTING).failureBehavior(FailureBehavior.LEAVE).build();
    }

    public static FileTransformerConfiguration defaultCreateOrAppend() {
        return (FileTransformerConfiguration)FileTransformerConfiguration.builder().fileWriteOption(FileWriteOption.CREATE_OR_APPEND_TO_EXISTING).failureBehavior(FailureBehavior.LEAVE).build();
    }

    @Override
    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTransformerConfiguration that = (FileTransformerConfiguration)o;
        if (this.fileWriteOption != that.fileWriteOption) {
            return false;
        }
        return this.failureBehavior == that.failureBehavior;
    }

    public int hashCode() {
        int result = this.fileWriteOption != null ? this.fileWriteOption.hashCode() : 0;
        result = 31 * result + (this.failureBehavior != null ? this.failureBehavior.hashCode() : 0);
        return result;
    }

    private static class DefaultBuilder
    implements Builder {
        private FileWriteOption fileWriteOption;
        private FailureBehavior failureBehavior;

        private DefaultBuilder() {
        }

        private DefaultBuilder(FileTransformerConfiguration fileTransformerConfiguration) {
            this.fileWriteOption = fileTransformerConfiguration.fileWriteOption;
            this.failureBehavior = fileTransformerConfiguration.failureBehavior;
        }

        @Override
        public Builder fileWriteOption(FileWriteOption fileWriteOption) {
            this.fileWriteOption = fileWriteOption;
            return this;
        }

        @Override
        public Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        public FileTransformerConfiguration build() {
            return new FileTransformerConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FileTransformerConfiguration> {
        public Builder fileWriteOption(FileWriteOption var1);

        public Builder failureBehavior(FailureBehavior var1);
    }

    public static enum FailureBehavior {
        DELETE,
        LEAVE;

    }

    public static enum FileWriteOption {
        CREATE_NEW,
        CREATE_OR_REPLACE_EXISTING,
        CREATE_OR_APPEND_TO_EXISTING;

    }
}

