/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.org.apache.http.impl.entity;

import org.apache.flink.kinesis.shaded.org.apache.http.Header;
import org.apache.flink.kinesis.shaded.org.apache.http.HeaderElement;
import org.apache.flink.kinesis.shaded.org.apache.http.HttpException;
import org.apache.flink.kinesis.shaded.org.apache.http.HttpMessage;
import org.apache.flink.kinesis.shaded.org.apache.http.ParseException;
import org.apache.flink.kinesis.shaded.org.apache.http.ProtocolException;
import org.apache.flink.kinesis.shaded.org.apache.http.annotation.Contract;
import org.apache.flink.kinesis.shaded.org.apache.http.annotation.ThreadingBehavior;
import org.apache.flink.kinesis.shaded.org.apache.http.entity.ContentLengthStrategy;
import org.apache.flink.kinesis.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LaxContentLengthStrategy
implements ContentLengthStrategy {
    public static final LaxContentLengthStrategy INSTANCE = new LaxContentLengthStrategy();
    private final int implicitLen;

    public LaxContentLengthStrategy(int implicitLen) {
        this.implicitLen = implicitLen;
    }

    public LaxContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        Args.notNull(message, "HTTP message");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        if (transferEncodingHeader != null) {
            HeaderElement[] encodings;
            try {
                encodings = transferEncodingHeader.getElements();
            }
            catch (ParseException px) {
                throw new ProtocolException("Invalid Transfer-Encoding header value: " + transferEncodingHeader, px);
            }
            int len = encodings.length;
            if ("identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                return -1L;
            }
            if (len > 0 && "chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                return -2L;
            }
            return -1L;
        }
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            long contentLen = -1L;
            Header[] headers = message.getHeaders("Content-Length");
            for (int i = headers.length - 1; i >= 0; --i) {
                Header header = headers[i];
                try {
                    contentLen = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
            }
            return contentLen >= 0L ? contentLen : -1L;
        }
        return this.implicitLen;
    }
}

