/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model;

import java.io.Serializable;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalMap;

public class AddTagsToStreamRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String streamName;
    private SdkInternalMap<String, String> tags;

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public AddTagsToStreamRequest withStreamName(String streamName) {
        this.setStreamName(streamName);
        return this;
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalMap();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? null : new SdkInternalMap<String, String>(tags);
    }

    public AddTagsToStreamRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public AddTagsToStreamRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new SdkInternalMap();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public AddTagsToStreamRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamName() != null) {
            sb.append("StreamName: ").append(this.getStreamName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToStreamRequest)) {
            return false;
        }
        AddTagsToStreamRequest other = (AddTagsToStreamRequest)obj;
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        if (other.getStreamName() != null && !other.getStreamName().equals(this.getStreamName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public AddTagsToStreamRequest clone() {
        return (AddTagsToStreamRequest)super.clone();
    }
}

