/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.RecordAdapter;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.InitializationInput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ShutdownInput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Record;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.Log;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.LogFactory;

public abstract class StreamsRecordProcessor
implements IRecordProcessor {
    private static final Log LOG = LogFactory.getLog(StreamsRecordProcessor.class);

    @Override
    public abstract void initialize(InitializationInput var1);

    @Override
    public void processRecords(ProcessRecordsInput processRecordsInput) {
        ArrayList<org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record> streamsRecords = new ArrayList<org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record>();
        if (processRecordsInput.getRecords() == null) {
            LOG.warn("ProcessRecordsInput's list of Records was null. Skipping.");
            return;
        }
        for (Record record : processRecordsInput.getRecords()) {
            if (record instanceof RecordAdapter) {
                streamsRecords.add(((RecordAdapter)record).getInternalObject());
                continue;
            }
            throw new IllegalArgumentException("Record is not an instance of RecordAdapter");
        }
        this.processStreamsRecords(streamsRecords, processRecordsInput.getCheckpointer());
    }

    public abstract void processStreamsRecords(List<org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record> var1, IRecordProcessorCheckpointer var2);

    @Override
    public abstract void shutdown(ShutdownInput var1);
}

