/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.BatchStatementError;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.BatchStatementResponseMarshaller;

public class BatchStatementResponse
implements Serializable,
Cloneable,
StructuredPojo {
    private BatchStatementError error;
    private String tableName;
    private Map<String, AttributeValue> item;

    public void setError(BatchStatementError error) {
        this.error = error;
    }

    public BatchStatementError getError() {
        return this.error;
    }

    public BatchStatementResponse withError(BatchStatementError error) {
        this.setError(error);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public BatchStatementResponse withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> item) {
        this.item = item;
    }

    public BatchStatementResponse withItem(Map<String, AttributeValue> item) {
        this.setItem(item);
        return this;
    }

    public BatchStatementResponse addItemEntry(String key, AttributeValue value) {
        if (null == this.item) {
            this.item = new HashMap<String, AttributeValue>();
        }
        if (this.item.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.item.put(key, value);
        return this;
    }

    public BatchStatementResponse clearItemEntries() {
        this.item = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getError() != null) {
            sb.append("Error: ").append(this.getError()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getItem() != null) {
            sb.append("Item: ").append(this.getItem());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStatementResponse)) {
            return false;
        }
        BatchStatementResponse other = (BatchStatementResponse)obj;
        if (other.getError() == null ^ this.getError() == null) {
            return false;
        }
        if (other.getError() != null && !other.getError().equals(this.getError())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        return other.getItem() == null || other.getItem().equals(this.getItem());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getError() == null ? 0 : this.getError().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getItem() == null ? 0 : this.getItem().hashCode());
        return hashCode;
    }

    public BatchStatementResponse clone() {
        try {
            return (BatchStatementResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchStatementResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

