/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.connectors.kinesis.KinesisPartitioner;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

@Internal
public final class RowDataFieldsKinesisPartitioner
extends KinesisPartitioner<RowData> {
    private static final long serialVersionUID = 1L;
    public static final int MAX_PARTITION_KEY_LENGTH = 256;
    public static final String DEFAULT_DELIMITER = String.valueOf('|');
    private final String delimiter;
    private final List<String> fieldNames;
    private final Map<String, RowData.FieldGetter> dynamicFieldGetters;
    private final StringBuilder keyBuffer = new StringBuilder();
    private Map<String, String> staticFields = Collections.emptyMap();
    private int keyBufferStaticPrefixLength = 0;
    private int fieldNamesStaticPrefixLength = 0;

    public RowDataFieldsKinesisPartitioner(RowType physicalType, List<String> partitionKeys) {
        this(physicalType, partitionKeys, DEFAULT_DELIMITER);
    }

    public RowDataFieldsKinesisPartitioner(RowType physicalType, List<String> partitionKeys, String delimiter) {
        Preconditions.checkNotNull((Object)physicalType, (String)"physicalType");
        Preconditions.checkNotNull(partitionKeys, (String)"partitionKeys");
        Preconditions.checkNotNull((Object)delimiter, (String)"delimiter");
        Preconditions.checkArgument((!partitionKeys.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a RowDataFieldsKinesisPartitioner for a non-partitioned table");
        Preconditions.checkArgument((partitionKeys.size() == new HashSet<String>(partitionKeys).size() ? 1 : 0) != 0, (Object)"The sequence of partition keys cannot contain duplicates");
        List fieldsList = physicalType.getFieldNames();
        ArrayList<String> badKeyNames = new ArrayList<String>();
        ArrayList<String> badKeyTypes = new ArrayList<String>();
        for (String fieldName : partitionKeys) {
            int index = fieldsList.indexOf(fieldName);
            if (index < 0) {
                badKeyNames.add(fieldName);
                continue;
            }
            if (LogicalTypeChecks.hasWellDefinedString((LogicalType)physicalType.getTypeAt(index))) continue;
            badKeyTypes.add(fieldName);
        }
        Preconditions.checkArgument((badKeyNames.size() == 0 ? 1 : 0) != 0, (String)"The following partition keys are not present in the table: %s", (Object[])new Object[]{String.join((CharSequence)", ", badKeyNames)});
        Preconditions.checkArgument((badKeyTypes.size() == 0 ? 1 : 0) != 0, (String)"The following partition keys have types that are not supported by Kinesis: %s", (Object[])new Object[]{String.join((CharSequence)", ", badKeyTypes)});
        this.delimiter = delimiter;
        this.fieldNames = partitionKeys;
        this.dynamicFieldGetters = new HashMap<String, RowData.FieldGetter>();
        for (String fieldName : partitionKeys) {
            RowType.RowField field = (RowType.RowField)physicalType.getFields().get(fieldsList.indexOf(fieldName));
            RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)field.getType(), (int)fieldsList.indexOf(field.getName()));
            this.dynamicFieldGetters.put(fieldName, fieldGetter);
        }
    }

    @Override
    public String getPartitionId(RowData element) {
        this.keyBuffer.setLength(this.keyBufferStaticPrefixLength);
        for (int i = this.fieldNamesStaticPrefixLength; i < this.fieldNames.size(); ++i) {
            String fieldName = this.fieldNames.get(i);
            if (!this.staticFields.containsKey(fieldName)) {
                this.keyBuffer.append(this.dynamicFieldGetters.get(fieldName).getFieldOrNull(element));
            } else {
                this.keyBuffer.append(this.staticFields.get(fieldName));
            }
            this.keyBuffer.append(this.delimiter);
            if (this.keyBuffer.length() >= 256) break;
        }
        int length = Math.min(this.keyBuffer.length() - this.delimiter.length(), 256);
        return this.keyBuffer.substring(0, length);
    }

    public void setStaticFields(Map<String, String> staticFields) {
        Preconditions.checkArgument((boolean)this.isPartitionKeySubset(staticFields.keySet()), (Object)String.format("Not all static field names (%s) are part of the partition key (%s).", String.join((CharSequence)", ", staticFields.keySet()), String.join((CharSequence)", ", this.fieldNames)));
        this.staticFields = new HashMap<String, String>(staticFields);
        this.updateKeyBufferStaticPrefix();
    }

    private boolean isPartitionKeySubset(Set<String> candidateSubset) {
        return new HashSet<String>(this.fieldNames).containsAll(candidateSubset);
    }

    private void updateKeyBufferStaticPrefix() {
        this.keyBuffer.setLength(0);
        this.fieldNamesStaticPrefixLength = 0;
        for (String fieldName : this.fieldNames) {
            if (!this.staticFields.containsKey(fieldName)) break;
            this.keyBuffer.append(this.staticFields.get(fieldName));
            this.keyBuffer.append(this.delimiter);
            ++this.fieldNamesStaticPrefixLength;
        }
        this.keyBufferStaticPrefixLength = this.keyBuffer.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowDataFieldsKinesisPartitioner that = (RowDataFieldsKinesisPartitioner)o;
        return Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.fieldNames, that.fieldNames) && Objects.equals(this.staticFields, that.staticFields) && Objects.equals(this.keyBufferStaticPrefixLength, that.keyBufferStaticPrefixLength) && Objects.equals(this.fieldNamesStaticPrefixLength, that.fieldNamesStaticPrefixLength);
    }

    public int hashCode() {
        return Objects.hash(this.delimiter, this.fieldNames, this.staticFields, this.keyBufferStaticPrefixLength, this.fieldNamesStaticPrefixLength);
    }
}

