/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.streaming.connectors.kinesis.FixedKinesisPartitioner;
import org.apache.flink.streaming.connectors.kinesis.KinesisPartitioner;
import org.apache.flink.streaming.connectors.kinesis.RandomKinesisPartitioner;
import org.apache.flink.streaming.connectors.kinesis.table.RowDataFieldsKinesisPartitioner;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class KinesisOptions {
    public static final String AWS_PROPERTIES_PREFIX = "aws.";
    public static final String CONSUMER_PREFIX = "scan.";
    public static final String PRODUCER_PREFIX = "sink.producer.";
    public static final String[] NON_VALIDATED_PREFIXES = new String[]{"aws.", "scan.", "sink.producer."};
    public static final ConfigOption<String> STREAM = ConfigOptions.key((String)"stream").stringType().noDefaultValue().withDescription("Name of the Kinesis stream backing this table.");
    public static final ConfigOption<String> SINK_PARTITIONER = ConfigOptions.key((String)"sink.partitioner").stringType().noDefaultValue().withDescription(Description.builder().text("Optional output partitioning from Flink's partitions into Kinesis shards. Sinks that write to tables defined with the %s clause always use a field-based partitioner and cannot define this option.", new InlineElement[]{TextElement.code((String)"PARTITION BY")}).linebreak().text("Valid enumerations are").list(new InlineElement[]{TextElement.text((String)"random (use a random partition key)"), TextElement.text((String)"fixed (each Flink partition ends up in at most one Kinesis shard)"), TextElement.text((String)"custom class name (use a custom %s subclass)", (InlineElement[])new InlineElement[]{TextElement.text((String)KinesisPartitioner.class.getName())})}).build());
    public static final ConfigOption<String> SINK_PARTITIONER_FIELD_DELIMITER = ConfigOptions.key((String)"sink.partitioner-field-delimiter").stringType().defaultValue((Object)"|").withDescription(Description.builder().text("Optional field delimiter for fields-based partitioner derived from a %s clause", new InlineElement[]{TextElement.code((String)"PARTITION BY")}).build());
    public static final String SINK_PARTITIONER_VALUE_FIXED = "fixed";
    public static final String SINK_PARTITIONER_VALUE_RANDOM = "random";
    public static final Set<String> TABLE_LEVEL_OPTIONS = new HashSet<String>(Arrays.asList(STREAM.key(), FactoryUtil.FORMAT.key(), SINK_PARTITIONER.key(), SINK_PARTITIONER_FIELD_DELIMITER.key()));

    private KinesisOptions() {
    }

    public static Properties getConsumerProperties(Map<String, String> tableOptions) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : tableOptions.entrySet()) {
            String sourceKey = entry.getKey();
            String sourceVal = entry.getValue();
            if (TABLE_LEVEL_OPTIONS.contains(sourceKey)) continue;
            if (sourceKey.startsWith(AWS_PROPERTIES_PREFIX)) {
                properties.put(KinesisOptions.translateAwsKey(sourceKey), sourceVal);
                continue;
            }
            if (!sourceKey.startsWith(CONSUMER_PREFIX)) continue;
            properties.put(KinesisOptions.translateConsumerKey(sourceKey), sourceVal);
        }
        return properties;
    }

    public static Properties getProducerProperties(Map<String, String> tableOptions) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : tableOptions.entrySet()) {
            String sourceKey = entry.getKey();
            String sourceVal = entry.getValue();
            if (TABLE_LEVEL_OPTIONS.contains(sourceKey)) continue;
            if (sourceKey.startsWith(AWS_PROPERTIES_PREFIX)) {
                properties.put(KinesisOptions.translateAwsKey(sourceKey), sourceVal);
                continue;
            }
            if (!sourceKey.startsWith(PRODUCER_PREFIX)) continue;
            properties.put(KinesisOptions.translateProducerKey(sourceKey), sourceVal);
        }
        return properties;
    }

    private static String translateAwsKey(String key) {
        if (!key.endsWith("credentials.provider")) {
            return key.replace("credentials.", "credentials.provider.");
        }
        return key;
    }

    private static String translateConsumerKey(String key) {
        String result = "flink." + key.substring(CONSUMER_PREFIX.length());
        if (result.endsWith("initpos-timestamp-format")) {
            return result.replace("initpos-timestamp-format", "initpos.timestamp.format");
        }
        if (result.endsWith("initpos-timestamp")) {
            return result.replace("initpos-timestamp", "initpos.timestamp");
        }
        return result;
    }

    private static String translateProducerKey(String key) {
        String suffix = key.substring(PRODUCER_PREFIX.length());
        return Arrays.stream(suffix.split("-")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(""));
    }

    public static KinesisPartitioner<RowData> getKinesisPartitioner(ReadableConfig tableOptions, RowType physicalType, List<String> partitionKeys, ClassLoader classLoader) {
        if (!partitionKeys.isEmpty()) {
            String delimiter = (String)tableOptions.get(SINK_PARTITIONER_FIELD_DELIMITER);
            return new RowDataFieldsKinesisPartitioner(physicalType, partitionKeys, delimiter);
        }
        if (!tableOptions.getOptional(SINK_PARTITIONER).isPresent()) {
            return new RandomKinesisPartitioner<RowData>();
        }
        String partitioner = (String)tableOptions.getOptional(SINK_PARTITIONER).get();
        if (SINK_PARTITIONER_VALUE_FIXED.equals(partitioner)) {
            return new FixedKinesisPartitioner<RowData>();
        }
        if (SINK_PARTITIONER_VALUE_RANDOM.equals(partitioner)) {
            return new RandomKinesisPartitioner<RowData>();
        }
        return KinesisOptions.initializePartitioner(partitioner, classLoader);
    }

    private static <T> KinesisPartitioner<T> initializePartitioner(String name, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(name, true, classLoader);
            if (!KinesisPartitioner.class.isAssignableFrom(clazz)) {
                throw new ValidationException(String.format("Partitioner class '%s' should have %s in its parents chain", name, KinesisPartitioner.class.getName()));
            }
            KinesisPartitioner partitioner = (KinesisPartitioner)InstantiationUtil.instantiate((String)name, KinesisPartitioner.class, (ClassLoader)classLoader);
            return partitioner;
        }
        catch (ClassNotFoundException | FlinkException e) {
            throw new ValidationException(String.format("Could not find and instantiate partitioner class '%s'", name), e);
        }
    }
}

