/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.internals.publisher.polling;

import java.util.Properties;
import org.apache.flink.annotation.Internal;

@Internal
public class PollingRecordPublisherConfiguration {
    private final boolean adaptiveReads;
    private final int maxNumberOfRecordsPerFetch;
    private final long fetchIntervalMillis;

    public PollingRecordPublisherConfiguration(Properties consumerConfig) {
        this.maxNumberOfRecordsPerFetch = Integer.parseInt(consumerConfig.getProperty("flink.shard.getrecords.maxrecordcount", Integer.toString(10000)));
        this.fetchIntervalMillis = Long.parseLong(consumerConfig.getProperty("flink.shard.getrecords.intervalmillis", Long.toString(200L)));
        this.adaptiveReads = Boolean.parseBoolean(consumerConfig.getProperty("flink.shard.adaptivereads", Boolean.toString(false)));
    }

    public boolean isAdaptiveReads() {
        return this.adaptiveReads;
    }

    public int getMaxNumberOfRecordsPerFetch() {
        return this.maxNumberOfRecordsPerFetch;
    }

    public long getFetchIntervalMillis() {
        return this.fetchIntervalMillis;
    }
}

