/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.internals.publisher.fanout;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.streaming.connectors.kinesis.config.ConsumerConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.util.KinesisConfigUtil;
import org.apache.flink.util.Preconditions;

public class FanOutRecordPublisherConfiguration {
    private final ConsumerConfigConstants.EFORegistrationType efoRegistrationType;
    @Nullable
    private String consumerName;
    private final Map<String, String> streamConsumerArns = new HashMap<String, String>();
    private final int subscribeToShardMaxRetries;
    private final Duration subscribeToShardTimeout;
    private final long subscribeToShardMaxBackoffMillis;
    private final long subscribeToShardBaseBackoffMillis;
    private final double subscribeToShardExpConstant;
    private final long registerStreamBaseBackoffMillis;
    private final long registerStreamMaxBackoffMillis;
    private final double registerStreamExpConstant;
    private final int registerStreamMaxRetries;
    private final Duration registerStreamConsumerTimeout;
    private final long deregisterStreamBaseBackoffMillis;
    private final long deregisterStreamMaxBackoffMillis;
    private final double deregisterStreamExpConstant;
    private final int deregisterStreamMaxRetries;
    private final Duration deregisterStreamConsumerTimeout;
    private final int describeStreamMaxRetries;
    private final long describeStreamBaseBackoffMillis;
    private final long describeStreamMaxBackoffMillis;
    private final double describeStreamExpConstant;
    private final int describeStreamConsumerMaxRetries;
    private final long describeStreamConsumerBaseBackoffMillis;
    private final long describeStreamConsumerMaxBackoffMillis;
    private final double describeStreamConsumerExpConstant;

    public FanOutRecordPublisherConfiguration(Properties configProps, List<String> streams) {
        Preconditions.checkArgument((boolean)configProps.getProperty("flink.stream.recordpublisher").equals(ConsumerConfigConstants.RecordPublisherType.EFO.toString()), (Object)"Only efo record publisher can register a FanOutProperties.");
        KinesisConfigUtil.validateEfoConfiguration(configProps, streams);
        this.efoRegistrationType = ConsumerConfigConstants.EFORegistrationType.valueOf(configProps.getProperty("flink.stream.efo.registration", ConsumerConfigConstants.EFORegistrationType.EAGER.toString()));
        if (this.efoRegistrationType == ConsumerConfigConstants.EFORegistrationType.EAGER || this.efoRegistrationType == ConsumerConfigConstants.EFORegistrationType.LAZY) {
            this.consumerName = configProps.getProperty("flink.stream.efo.consumername");
        }
        for (String stream : streams) {
            String key = ConsumerConfigConstants.efoConsumerArn(stream);
            if (!configProps.containsKey(key)) continue;
            this.streamConsumerArns.put(stream, configProps.getProperty(key));
        }
        this.subscribeToShardMaxRetries = Optional.ofNullable(configProps.getProperty("flink.shard.subscribetoshard.maxretries")).map(Integer::parseInt).orElse(10);
        this.subscribeToShardTimeout = Optional.ofNullable(configProps.getProperty("flink.shard.subscribetoshard.timeout")).map(Integer::parseInt).map(Duration::ofSeconds).orElse(ConsumerConfigConstants.DEFAULT_SUBSCRIBE_TO_SHARD_TIMEOUT);
        this.subscribeToShardBaseBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.shard.subscribetoshard.backoff.base")).map(Long::parseLong).orElse(1000L);
        this.subscribeToShardMaxBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.shard.subscribetoshard.backoff.max")).map(Long::parseLong).orElse(2000L);
        this.subscribeToShardExpConstant = Optional.ofNullable(configProps.getProperty("flink.shard.subscribetoshard.backoff.expconst")).map(Double::parseDouble).orElse(1.5);
        this.registerStreamBaseBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.stream.registerstreamconsumer.backoff.base")).map(Long::parseLong).orElse(500L);
        this.registerStreamMaxBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.stream.registerstreamconsumer.backoff.max")).map(Long::parseLong).orElse(2000L);
        this.registerStreamExpConstant = Optional.ofNullable(configProps.getProperty("flink.stream.registerstreamconsumer.backoff.expconst")).map(Double::parseDouble).orElse(1.5);
        this.registerStreamMaxRetries = Optional.ofNullable(configProps.getProperty("flink.stream.registerstreamconsumer.maxretries")).map(Integer::parseInt).orElse(10);
        this.registerStreamConsumerTimeout = Optional.ofNullable(configProps.getProperty("flink.stream.registerstreamconsumer.timeout")).map(Integer::parseInt).map(Duration::ofSeconds).orElse(ConsumerConfigConstants.DEFAULT_REGISTER_STREAM_TIMEOUT);
        this.deregisterStreamBaseBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.stream.deregisterstreamconsumer.backoff.base")).map(Long::parseLong).orElse(500L);
        this.deregisterStreamMaxBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.stream.deregisterstreamconsumer.backoff.max")).map(Long::parseLong).orElse(2000L);
        this.deregisterStreamExpConstant = Optional.ofNullable(configProps.getProperty("flink.stream.deregisterstreamconsumer.backoff.expconst")).map(Double::parseDouble).orElse(1.5);
        this.deregisterStreamMaxRetries = Optional.ofNullable(configProps.getProperty("flink.stream.deregisterstreamconsumer.maxretries")).map(Integer::parseInt).orElse(10);
        this.deregisterStreamConsumerTimeout = Optional.ofNullable(configProps.getProperty("flink.stream.deregisterstreamconsumer.timeout")).map(Integer::parseInt).map(Duration::ofSeconds).orElse(ConsumerConfigConstants.DEFAULT_DEREGISTER_STREAM_TIMEOUT);
        this.describeStreamMaxRetries = Optional.ofNullable(configProps.getProperty("flink.stream.describe.maxretries")).map(Integer::parseInt).orElse(50);
        this.describeStreamBaseBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.stream.describe.backoff.base")).map(Long::parseLong).orElse(2000L);
        this.describeStreamMaxBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.stream.describe.backoff.max")).map(Long::parseLong).orElse(5000L);
        this.describeStreamExpConstant = Optional.ofNullable(configProps.getProperty("flink.stream.describe.backoff.expconst")).map(Double::parseDouble).orElse(1.5);
        this.describeStreamConsumerMaxRetries = Optional.ofNullable(configProps.getProperty("flink.stream.describestreamconsumer.maxretries")).map(Integer::parseInt).orElse(50);
        this.describeStreamConsumerBaseBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.stream.describestreamconsumer.backoff.base")).map(Long::parseLong).orElse(2000L);
        this.describeStreamConsumerMaxBackoffMillis = Optional.ofNullable(configProps.getProperty("flink.stream.describestreamconsumer.backoff.max")).map(Long::parseLong).orElse(5000L);
        this.describeStreamConsumerExpConstant = Optional.ofNullable(configProps.getProperty("flink.stream.describestreamconsumer.backoff.expconst")).map(Double::parseDouble).orElse(1.5);
    }

    public int getSubscribeToShardMaxRetries() {
        return this.subscribeToShardMaxRetries;
    }

    public Duration getSubscribeToShardTimeout() {
        return this.subscribeToShardTimeout;
    }

    public long getSubscribeToShardMaxBackoffMillis() {
        return this.subscribeToShardMaxBackoffMillis;
    }

    public long getSubscribeToShardBaseBackoffMillis() {
        return this.subscribeToShardBaseBackoffMillis;
    }

    public double getSubscribeToShardExpConstant() {
        return this.subscribeToShardExpConstant;
    }

    public long getRegisterStreamBaseBackoffMillis() {
        return this.registerStreamBaseBackoffMillis;
    }

    public long getRegisterStreamMaxBackoffMillis() {
        return this.registerStreamMaxBackoffMillis;
    }

    public double getRegisterStreamExpConstant() {
        return this.registerStreamExpConstant;
    }

    public int getRegisterStreamMaxRetries() {
        return this.registerStreamMaxRetries;
    }

    public Duration getRegisterStreamConsumerTimeout() {
        return this.registerStreamConsumerTimeout;
    }

    public long getDeregisterStreamBaseBackoffMillis() {
        return this.deregisterStreamBaseBackoffMillis;
    }

    public long getDeregisterStreamMaxBackoffMillis() {
        return this.deregisterStreamMaxBackoffMillis;
    }

    public double getDeregisterStreamExpConstant() {
        return this.deregisterStreamExpConstant;
    }

    public int getDeregisterStreamMaxRetries() {
        return this.deregisterStreamMaxRetries;
    }

    public Duration getDeregisterStreamConsumerTimeout() {
        return this.deregisterStreamConsumerTimeout;
    }

    public int getDescribeStreamMaxRetries() {
        return this.describeStreamMaxRetries;
    }

    public long getDescribeStreamBaseBackoffMillis() {
        return this.describeStreamBaseBackoffMillis;
    }

    public long getDescribeStreamMaxBackoffMillis() {
        return this.describeStreamMaxBackoffMillis;
    }

    public double getDescribeStreamExpConstant() {
        return this.describeStreamExpConstant;
    }

    public int getDescribeStreamConsumerMaxRetries() {
        return this.describeStreamConsumerMaxRetries;
    }

    public long getDescribeStreamConsumerBaseBackoffMillis() {
        return this.describeStreamConsumerBaseBackoffMillis;
    }

    public long getDescribeStreamConsumerMaxBackoffMillis() {
        return this.describeStreamConsumerMaxBackoffMillis;
    }

    public double getDescribeStreamConsumerExpConstant() {
        return this.describeStreamConsumerExpConstant;
    }

    public ConsumerConfigConstants.EFORegistrationType getEfoRegistrationType() {
        return this.efoRegistrationType;
    }

    public Optional<String> getConsumerName() {
        return Optional.ofNullable(this.consumerName);
    }

    public Optional<String> getStreamConsumerArn(String stream) {
        return Optional.ofNullable(this.streamConsumerArns.get(stream));
    }
}

