/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.cache;

import java.time.Instant;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;

@SdkProtectedApi
public final class RefreshResult<T> {
    private final T value;
    private final Instant staleTime;
    private final Instant prefetchTime;

    private RefreshResult(Builder<T> builder) {
        this.value = ((Builder)builder).value;
        this.staleTime = ((Builder)builder).staleTime;
        this.prefetchTime = ((Builder)builder).prefetchTime;
    }

    public static <T> Builder<T> builder(T value) {
        return new Builder(value);
    }

    public T value() {
        return this.value;
    }

    public Instant staleTime() {
        return this.staleTime;
    }

    public Instant prefetchTime() {
        return this.prefetchTime;
    }

    public static final class Builder<T> {
        private final T value;
        private Instant staleTime = Instant.MAX;
        private Instant prefetchTime = Instant.MAX;

        private Builder(T value) {
            this.value = value;
        }

        public Builder<T> staleTime(Instant staleTime) {
            this.staleTime = staleTime;
            return this;
        }

        public Builder<T> prefetchTime(Instant prefetchTime) {
            this.prefetchTime = prefetchTime;
            return this;
        }

        public RefreshResult<T> build() {
            return new RefreshResult(this);
        }
    }
}

