/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;

@SdkProtectedApi
public final class CompletableFutureUtils {
    private CompletableFutureUtils() {
    }

    public static <U> CompletableFuture<U> failedFuture(Throwable t) {
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(t);
        return cf;
    }

    public static CompletionException errorAsCompletionException(Throwable t) {
        if (t instanceof CompletionException) {
            return (CompletionException)t;
        }
        return new CompletionException(t);
    }

    public static <T> CompletableFuture<T> forwardExceptionTo(CompletableFuture<T> src, CompletableFuture<?> dst) {
        src.whenComplete((r, e) -> {
            if (e != null) {
                dst.completeExceptionally((Throwable)e);
            }
        });
        return src;
    }
}

