/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.paginators;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.kinesis.shaded.org.reactivestreams.Subscriber;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.SdkPublisher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.util.PaginatorUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;

public class ListStreamConsumersPublisher
implements SdkPublisher<ListStreamConsumersResponse> {
    private final KinesisAsyncClient client;
    private final ListStreamConsumersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamConsumersPublisher(KinesisAsyncClient client, ListStreamConsumersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamConsumersPublisher(KinesisAsyncClient client, ListStreamConsumersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamConsumersResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListStreamConsumersResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStreamConsumersResponseFetcher
    implements AsyncPageFetcher<ListStreamConsumersResponse> {
        private ListStreamConsumersResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListStreamConsumersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListStreamConsumersResponse> nextPage(ListStreamConsumersResponse previousPage) {
            if (previousPage == null) {
                return ListStreamConsumersPublisher.this.client.listStreamConsumers(ListStreamConsumersPublisher.this.firstRequest);
            }
            return ListStreamConsumersPublisher.this.client.listStreamConsumers((ListStreamConsumersRequest)ListStreamConsumersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

