/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MetricsName {
    INCOMING_BYTES("IncomingBytes"),
    INCOMING_RECORDS("IncomingRecords"),
    OUTGOING_BYTES("OutgoingBytes"),
    OUTGOING_RECORDS("OutgoingRecords"),
    WRITE_PROVISIONED_THROUGHPUT_EXCEEDED("WriteProvisionedThroughputExceeded"),
    READ_PROVISIONED_THROUGHPUT_EXCEEDED("ReadProvisionedThroughputExceeded"),
    ITERATOR_AGE_MILLISECONDS("IteratorAgeMilliseconds"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MetricsName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricsName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MetricsName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricsName> knownValues() {
        return Stream.of(MetricsName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

