/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, CreateStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(CreateStreamRequest.getter(CreateStreamRequest::streamName)).setter(CreateStreamRequest.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("ShardCount").getter(CreateStreamRequest.getter(CreateStreamRequest::shardCount)).setter(CreateStreamRequest.setter(Builder::shardCount)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardCount").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, SHARD_COUNT_FIELD));
    private final String streamName;
    private final Integer shardCount;

    private CreateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardCount = builder.shardCount;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final Integer shardCount() {
        return this.shardCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamRequest)) {
            return false;
        }
        CreateStreamRequest other = (CreateStreamRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.shardCount(), other.shardCount());
    }

    public final String toString() {
        return ToString.builder("CreateStreamRequest").add("StreamName", this.streamName()).add("ShardCount", this.shardCount()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "ShardCount": {
                return Optional.ofNullable(clazz.cast(this.shardCount()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamRequest, T> g) {
        return obj -> g.apply((CreateStreamRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer shardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.shardCount(model.shardCount);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getShardCount() {
            return this.shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamRequest build() {
            return new CreateStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamRequest> {
        public Builder streamName(String var1);

        public Builder shardCount(Integer var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

