/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.RetryMode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.RetryPolicy;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.RetryPolicyContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.conditions.AndRetryCondition;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;

@SdkInternalApi
final class KinesisRetryPolicy {
    private KinesisRetryPolicy() {
    }

    public static RetryPolicy resolveRetryPolicy(SdkClientConfiguration config) {
        RetryPolicy configuredRetryPolicy = config.option(SdkClientOption.RETRY_POLICY);
        if (configuredRetryPolicy != null) {
            return KinesisRetryPolicy.addRetryConditions(configuredRetryPolicy);
        }
        RetryMode retryMode = RetryMode.resolver().profileFile(() -> config.option(SdkClientOption.PROFILE_FILE)).profileName(config.option(SdkClientOption.PROFILE_NAME)).resolve();
        return AwsRetryPolicy.forRetryMode(retryMode).toBuilder().applyMutation(KinesisRetryPolicy::addRetryConditions).additionalRetryConditionsAllowed(false).build();
    }

    public static RetryPolicy addRetryConditions(RetryPolicy policy) {
        if (!policy.additionalRetryConditionsAllowed()) {
            return policy;
        }
        return policy.toBuilder().applyMutation(KinesisRetryPolicy::addRetryConditions).build();
    }

    public static void addRetryConditions(RetryPolicy.Builder policy) {
        policy.retryCondition(AndRetryCondition.create(KinesisRetryPolicy::isNotSubscribeToShard, policy.retryCondition()));
    }

    private static boolean isNotSubscribeToShard(RetryPolicyContext context) {
        return !(context.originalRequest() instanceof SubscribeToShardRequest);
    }
}

