/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServiceMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class WafRegionalServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "waf-regional";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put("af-south-1", "waf-regional.af-south-1.amazonaws.com").put("ap-east-1", "waf-regional.ap-east-1.amazonaws.com").put("ap-northeast-1", "waf-regional.ap-northeast-1.amazonaws.com").put("ap-northeast-2", "waf-regional.ap-northeast-2.amazonaws.com").put("ap-northeast-3", "waf-regional.ap-northeast-3.amazonaws.com").put("ap-south-1", "waf-regional.ap-south-1.amazonaws.com").put("ap-southeast-1", "waf-regional.ap-southeast-1.amazonaws.com").put("ap-southeast-2", "waf-regional.ap-southeast-2.amazonaws.com").put("ca-central-1", "waf-regional.ca-central-1.amazonaws.com").put("eu-central-1", "waf-regional.eu-central-1.amazonaws.com").put("eu-north-1", "waf-regional.eu-north-1.amazonaws.com").put("eu-south-1", "waf-regional.eu-south-1.amazonaws.com").put("eu-west-1", "waf-regional.eu-west-1.amazonaws.com").put("eu-west-2", "waf-regional.eu-west-2.amazonaws.com").put("eu-west-3", "waf-regional.eu-west-3.amazonaws.com").put("fips-af-south-1", "waf-regional-fips.af-south-1.amazonaws.com").put("fips-ap-east-1", "waf-regional-fips.ap-east-1.amazonaws.com").put("fips-ap-northeast-1", "waf-regional-fips.ap-northeast-1.amazonaws.com").put("fips-ap-northeast-2", "waf-regional-fips.ap-northeast-2.amazonaws.com").put("fips-ap-northeast-3", "waf-regional-fips.ap-northeast-3.amazonaws.com").put("fips-ap-south-1", "waf-regional-fips.ap-south-1.amazonaws.com").put("fips-ap-southeast-1", "waf-regional-fips.ap-southeast-1.amazonaws.com").put("fips-ap-southeast-2", "waf-regional-fips.ap-southeast-2.amazonaws.com").put("fips-ca-central-1", "waf-regional-fips.ca-central-1.amazonaws.com").put("fips-eu-central-1", "waf-regional-fips.eu-central-1.amazonaws.com").put("fips-eu-north-1", "waf-regional-fips.eu-north-1.amazonaws.com").put("fips-eu-south-1", "waf-regional-fips.eu-south-1.amazonaws.com").put("fips-eu-west-1", "waf-regional-fips.eu-west-1.amazonaws.com").put("fips-eu-west-2", "waf-regional-fips.eu-west-2.amazonaws.com").put("fips-eu-west-3", "waf-regional-fips.eu-west-3.amazonaws.com").put("fips-me-south-1", "waf-regional-fips.me-south-1.amazonaws.com").put("fips-sa-east-1", "waf-regional-fips.sa-east-1.amazonaws.com").put("fips-us-east-1", "waf-regional-fips.us-east-1.amazonaws.com").put("fips-us-east-2", "waf-regional-fips.us-east-2.amazonaws.com").put("fips-us-west-1", "waf-regional-fips.us-west-1.amazonaws.com").put("fips-us-west-2", "waf-regional-fips.us-west-2.amazonaws.com").put("me-south-1", "waf-regional.me-south-1.amazonaws.com").put("sa-east-1", "waf-regional.sa-east-1.amazonaws.com").put("us-east-1", "waf-regional.us-east-1.amazonaws.com").put("us-east-2", "waf-regional.us-east-2.amazonaws.com").put("us-west-1", "waf-regional.us-west-1.amazonaws.com").put("us-west-2", "waf-regional.us-west-2.amazonaws.com").put("cn-north-1", "waf-regional.cn-north-1.amazonaws.com.cn").put("cn-northwest-1", "waf-regional.cn-northwest-1.amazonaws.com.cn").put("fips-cn-north-1", "waf-regional-fips.cn-north-1.amazonaws.com.cn").put("fips-cn-northwest-1", "waf-regional-fips.cn-northwest-1.amazonaws.com.cn").put("fips-us-gov-east-1", "waf-regional-fips.us-gov-east-1.amazonaws.com").put("fips-us-gov-west-1", "waf-regional-fips.us-gov-west-1.amazonaws.com").put("us-gov-east-1", "waf-regional.us-gov-east-1.amazonaws.com").put("us-gov-west-1", "waf-regional.us-gov-west-1.amazonaws.com").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-north-1"), Region.of("eu-south-1"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("fips-af-south-1"), Region.of("fips-ap-east-1"), Region.of("fips-ap-northeast-1"), Region.of("fips-ap-northeast-2"), Region.of("fips-ap-northeast-3"), Region.of("fips-ap-south-1"), Region.of("fips-ap-southeast-1"), Region.of("fips-ap-southeast-2"), Region.of("fips-ca-central-1"), Region.of("fips-eu-central-1"), Region.of("fips-eu-north-1"), Region.of("fips-eu-south-1"), Region.of("fips-eu-west-1"), Region.of("fips-eu-west-2"), Region.of("fips-eu-west-3"), Region.of("fips-me-south-1"), Region.of("fips-sa-east-1"), Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"), Region.of("me-south-1"), Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("fips-cn-north-1"), Region.of("fips-cn-northwest-1"), Region.of("fips-us-gov-east-1"), Region.of("fips-us-gov-west-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put("af-south-1", "af-south-1").put("ap-east-1", "ap-east-1").put("ap-northeast-1", "ap-northeast-1").put("ap-northeast-2", "ap-northeast-2").put("ap-northeast-3", "ap-northeast-3").put("ap-south-1", "ap-south-1").put("ap-southeast-1", "ap-southeast-1").put("ap-southeast-2", "ap-southeast-2").put("ca-central-1", "ca-central-1").put("eu-central-1", "eu-central-1").put("eu-north-1", "eu-north-1").put("eu-south-1", "eu-south-1").put("eu-west-1", "eu-west-1").put("eu-west-2", "eu-west-2").put("eu-west-3", "eu-west-3").put("fips-af-south-1", "af-south-1").put("fips-ap-east-1", "ap-east-1").put("fips-ap-northeast-1", "ap-northeast-1").put("fips-ap-northeast-2", "ap-northeast-2").put("fips-ap-northeast-3", "ap-northeast-3").put("fips-ap-south-1", "ap-south-1").put("fips-ap-southeast-1", "ap-southeast-1").put("fips-ap-southeast-2", "ap-southeast-2").put("fips-ca-central-1", "ca-central-1").put("fips-eu-central-1", "eu-central-1").put("fips-eu-north-1", "eu-north-1").put("fips-eu-south-1", "eu-south-1").put("fips-eu-west-1", "eu-west-1").put("fips-eu-west-2", "eu-west-2").put("fips-eu-west-3", "eu-west-3").put("fips-me-south-1", "me-south-1").put("fips-sa-east-1", "sa-east-1").put("fips-us-east-1", "us-east-1").put("fips-us-east-2", "us-east-2").put("fips-us-west-1", "us-west-1").put("fips-us-west-2", "us-west-2").put("me-south-1", "me-south-1").put("sa-east-1", "sa-east-1").put("us-east-1", "us-east-1").put("us-east-2", "us-east-2").put("us-west-1", "us-west-1").put("us-west-2", "us-west-2").put("cn-north-1", "cn-north-1").put("cn-northwest-1", "cn-northwest-1").put("fips-cn-north-1", "cn-north-1").put("fips-cn-northwest-1", "cn-northwest-1").put("fips-us-gov-east-1", "us-gov-east-1").put("fips-us-gov-west-1", "us-gov-west-1").put("us-gov-east-1", "us-gov-east-1").put("us-gov-west-1", "us-gov-west-1").build();
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}

