/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServiceMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class SupportServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "support";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put("aws-global", "support.us-east-1.amazonaws.com").put("aws-cn-global", "support.cn-north-1.amazonaws.com.cn").put("aws-iso-global", "support.us-iso-east-1.c2s.ic.gov").put("aws-iso-b-global", "support.us-isob-east-1.sc2s.sgov.gov").put("aws-us-gov-global", "support.us-gov-west-1.amazonaws.com").put("fips-us-gov-west-1", "support.us-gov-west-1.amazonaws.com").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("aws-global"), Region.of("aws-cn-global"), Region.of("aws-us-gov-global"), Region.of("fips-us-gov-west-1"), Region.of("aws-iso-global"), Region.of("aws-iso-b-global")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put("aws-global", "us-east-1").put("aws-cn-global", "cn-north-1").put("aws-iso-global", "us-iso-east-1").put("aws-iso-b-global", "us-isob-east-1").put("aws-us-gov-global", "us-gov-west-1").put("fips-us-gov-west-1", "us-gov-west-1").build();
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}

