/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServiceMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class IoteventsdataServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "ioteventsdata";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put("ap-northeast-1", "data.iotevents.ap-northeast-1.amazonaws.com").put("ap-northeast-2", "data.iotevents.ap-northeast-2.amazonaws.com").put("ap-southeast-1", "data.iotevents.ap-southeast-1.amazonaws.com").put("ap-southeast-2", "data.iotevents.ap-southeast-2.amazonaws.com").put("eu-central-1", "data.iotevents.eu-central-1.amazonaws.com").put("eu-west-1", "data.iotevents.eu-west-1.amazonaws.com").put("eu-west-2", "data.iotevents.eu-west-2.amazonaws.com").put("us-east-1", "data.iotevents.us-east-1.amazonaws.com").put("us-east-2", "data.iotevents.us-east-2.amazonaws.com").put("us-west-2", "data.iotevents.us-west-2.amazonaws.com").put("cn-north-1", "data.iotevents.cn-north-1.amazonaws.com.cn").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("eu-central-1"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-2"), Region.of("cn-north-1")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put("ap-northeast-1", "ap-northeast-1").put("ap-northeast-2", "ap-northeast-2").put("ap-southeast-1", "ap-southeast-1").put("ap-southeast-2", "ap-southeast-2").put("eu-central-1", "eu-central-1").put("eu-west-1", "eu-west-1").put("eu-west-2", "eu-west-2").put("us-east-1", "us-east-1").put("us-east-2", "us-east-2").put("us-west-2", "us-west-2").put("cn-north-1", "cn-north-1").build();
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}

