/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.DefaultServiceMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.MetadataLoader;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.PartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.RegionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServiceMetadataConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServicePartitionMetadata;

@SdkPublicApi
public interface ServiceMetadata {
    public URI endpointFor(Region var1);

    public Region signingRegion(Region var1);

    public List<Region> regions();

    public List<ServicePartitionMetadata> servicePartitions();

    public static ServiceMetadata of(String serviceEndpointPrefix) {
        ServiceMetadata metadata = MetadataLoader.serviceMetadata(serviceEndpointPrefix);
        return metadata == null ? new DefaultServiceMetadata(serviceEndpointPrefix) : metadata;
    }

    default public String computeEndpoint(String endpointPrefix, Map<String, String> partitionOverriddenEndpoints, Region region) {
        RegionMetadata regionMetadata = RegionMetadata.of(region);
        if (regionMetadata != null) {
            return String.format("%s.%s.%s", endpointPrefix, region.id(), regionMetadata.domain());
        }
        PartitionMetadata partitionMetadata = MetadataLoader.partitionMetadata(region);
        String endpointPattern = partitionOverriddenEndpoints.getOrDefault(partitionMetadata.id(), partitionMetadata.hostname());
        return endpointPattern.replace("{region}", region.id()).replace("{service}", endpointPrefix).replace("{dnsSuffix}", partitionMetadata.dnsSuffix());
    }

    default public ServiceMetadata reconfigure(ServiceMetadataConfiguration configuration) {
        return this;
    }

    default public ServiceMetadata reconfigure(Consumer<ServiceMetadataConfiguration.Builder> consumer) {
        ServiceMetadataConfiguration.Builder configuration = ServiceMetadataConfiguration.builder();
        consumer.accept(configuration);
        return this.reconfigure(configuration.build());
    }
}

