/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServiceMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public class DefaultServiceMetadata
implements ServiceMetadata {
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final List<Region> REGIONS = new ArrayList<Region>();
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().build();
    private final String endpointPrefix;

    public DefaultServiceMetadata(String endpointPrefix) {
        this.endpointPrefix = endpointPrefix;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(this.computeEndpoint(this.endpointPrefix, new HashMap<String, String>(), region));
    }

    @Override
    public Region signingRegion(Region region) {
        return region;
    }

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return Collections.emptyList();
    }
}

