/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryProtocolUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshallerRegistry;

@SdkInternalApi
public final class QueryUnmarshallerContext {
    private final QueryUnmarshallerRegistry registry;
    private final QueryProtocolUnmarshaller protocolUnmarshaller;

    private QueryUnmarshallerContext(Builder builder) {
        this.registry = builder.registry;
        this.protocolUnmarshaller = builder.protocolUnmarshaller;
    }

    public QueryProtocolUnmarshaller protocolUnmarshaller() {
        return this.protocolUnmarshaller;
    }

    public <T> QueryUnmarshaller<Object> getUnmarshaller(MarshallLocation marshallLocation, MarshallingType<T> marshallingType) {
        return this.registry.getUnmarshaller(marshallLocation, marshallingType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private QueryUnmarshallerRegistry registry;
        private QueryProtocolUnmarshaller protocolUnmarshaller;

        private Builder() {
        }

        public Builder registry(QueryUnmarshallerRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder protocolUnmarshaller(QueryProtocolUnmarshaller protocolUnmarshaller) {
            this.protocolUnmarshaller = protocolUnmarshaller;
            return this;
        }

        public QueryUnmarshallerContext build() {
            return new QueryUnmarshallerContext(this);
        }
    }
}

