/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.unmarshall;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkBytes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.io.ReleasableInputStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.ListTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.MapTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.PayloadTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.TimestampFormatTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.StringToInstant;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.StringToValueConverter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.MarshallerUtil;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.JsonDomParser;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.dom.SdkJsonNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.unmarshall.HeaderUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerRegistry;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.Buildable;

@SdkInternalApi
@ThreadSafe
public final class JsonProtocolUnmarshaller {
    public final StringToValueConverter.StringToValue<Instant> instantStringToValue;
    private final JsonUnmarshallerRegistry registry;
    private final JsonDomParser parser;

    private JsonProtocolUnmarshaller(Builder builder) {
        this.parser = builder.parser;
        this.instantStringToValue = StringToInstant.create(new HashMap<MarshallLocation, TimestampFormatTrait.Format>(builder.defaultTimestampFormats));
        this.registry = JsonProtocolUnmarshaller.createUnmarshallerRegistry(this.instantStringToValue);
    }

    private static JsonUnmarshallerRegistry createUnmarshallerRegistry(StringToValueConverter.StringToValue<Instant> instantStringToValue) {
        return JsonUnmarshallerRegistry.builder().statusCodeUnmarshaller(MarshallingType.INTEGER, (context, json, f) -> context.response().statusCode()).headerUnmarshaller(MarshallingType.STRING, HeaderUnmarshaller.STRING).headerUnmarshaller(MarshallingType.INTEGER, HeaderUnmarshaller.INTEGER).headerUnmarshaller(MarshallingType.LONG, HeaderUnmarshaller.LONG).headerUnmarshaller(MarshallingType.SHORT, HeaderUnmarshaller.SHORT).headerUnmarshaller(MarshallingType.DOUBLE, HeaderUnmarshaller.DOUBLE).headerUnmarshaller(MarshallingType.BOOLEAN, HeaderUnmarshaller.BOOLEAN).headerUnmarshaller(MarshallingType.INSTANT, HeaderUnmarshaller.createInstantHeaderUnmarshaller(instantStringToValue)).headerUnmarshaller(MarshallingType.FLOAT, HeaderUnmarshaller.FLOAT).payloadUnmarshaller(MarshallingType.STRING, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_STRING)).payloadUnmarshaller(MarshallingType.INTEGER, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_INTEGER)).payloadUnmarshaller(MarshallingType.LONG, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_LONG)).payloadUnmarshaller(MarshallingType.SHORT, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_SHORT)).payloadUnmarshaller(MarshallingType.FLOAT, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_FLOAT)).payloadUnmarshaller(MarshallingType.DOUBLE, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_DOUBLE)).payloadUnmarshaller(MarshallingType.BIG_DECIMAL, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_BIG_DECIMAL)).payloadUnmarshaller(MarshallingType.BOOLEAN, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_BOOLEAN)).payloadUnmarshaller(MarshallingType.SDK_BYTES, JsonProtocolUnmarshaller::unmarshallSdkBytes).payloadUnmarshaller(MarshallingType.INSTANT, new SimpleTypeJsonUnmarshaller(instantStringToValue)).payloadUnmarshaller(MarshallingType.SDK_POJO, JsonProtocolUnmarshaller::unmarshallStructured).payloadUnmarshaller(MarshallingType.LIST, JsonProtocolUnmarshaller::unmarshallList).payloadUnmarshaller(MarshallingType.MAP, JsonProtocolUnmarshaller::unmarshallMap).build();
    }

    private static SdkBytes unmarshallSdkBytes(JsonUnmarshallerContext context, SdkJsonNode jsonContent, SdkField<SdkBytes> field) {
        if (jsonContent == null || jsonContent.isNull()) {
            return null;
        }
        if (jsonContent.embeddedObject() != null) {
            return SdkBytes.fromByteArray((byte[])jsonContent.embeddedObject());
        }
        return StringToValueConverter.TO_SDK_BYTES.convert(jsonContent.asText(), field);
    }

    private static SdkPojo unmarshallStructured(JsonUnmarshallerContext context, SdkJsonNode jsonContent, SdkField<SdkPojo> f) {
        if (jsonContent == null || jsonContent.isNull()) {
            return null;
        }
        return JsonProtocolUnmarshaller.unmarshallStructured(f.constructor().get(), jsonContent, context);
    }

    private static Map<String, ?> unmarshallMap(JsonUnmarshallerContext context, SdkJsonNode jsonContent, SdkField<Map<String, ?>> field) {
        if (jsonContent == null || jsonContent.isNull()) {
            return null;
        }
        SdkField valueInfo = field.getTrait(MapTrait.class).valueFieldInfo();
        HashMap map = new HashMap();
        jsonContent.fields().forEach((fieldName, value) -> {
            JsonUnmarshaller<Object> unmarshaller = context.getUnmarshaller(valueInfo.location(), valueInfo.marshallingType());
            map.put(fieldName, unmarshaller.unmarshall(context, (SdkJsonNode)value, valueInfo));
        });
        return map;
    }

    private static List<?> unmarshallList(JsonUnmarshallerContext context, SdkJsonNode jsonContent, SdkField<List<?>> field) {
        if (jsonContent == null || jsonContent.isNull()) {
            return null;
        }
        return jsonContent.items().stream().map(item -> {
            SdkField memberInfo = field.getTrait(ListTrait.class).memberFieldInfo();
            JsonUnmarshaller<Object> unmarshaller = context.getUnmarshaller(memberInfo.location(), memberInfo.marshallingType());
            return unmarshaller.unmarshall(context, (SdkJsonNode)item, memberInfo);
        }).collect(Collectors.toList());
    }

    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response) throws IOException {
        if (this.hasPayloadMembersOnUnmarshall(sdkPojo) && !this.hasExplicitBlobPayloadMember(sdkPojo) && response.content().isPresent()) {
            SdkJsonNode jsonNode = this.parser.parse((InputStream)ReleasableInputStream.wrap(response.content().get()).disableClose());
            return this.unmarshall(sdkPojo, response, jsonNode);
        }
        return this.unmarshall(sdkPojo, response, null);
    }

    private boolean hasExplicitBlobPayloadMember(SdkPojo sdkPojo) {
        return sdkPojo.sdkFields().stream().anyMatch(f -> JsonProtocolUnmarshaller.isExplicitPayloadMember(f) && f.marshallingType() == MarshallingType.SDK_BYTES);
    }

    private static boolean isExplicitPayloadMember(SdkField<?> f) {
        return f.containsTrait(PayloadTrait.class);
    }

    private boolean hasPayloadMembersOnUnmarshall(SdkPojo sdkPojo) {
        return sdkPojo.sdkFields().stream().anyMatch(f -> f.location() == MarshallLocation.PAYLOAD || MarshallerUtil.locationInUri(f.location()));
    }

    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response, SdkJsonNode jsonContent) {
        JsonUnmarshallerContext context = JsonUnmarshallerContext.builder().unmarshallerRegistry(this.registry).response(response).build();
        return JsonProtocolUnmarshaller.unmarshallStructured(sdkPojo, jsonContent, context);
    }

    private static <TypeT extends SdkPojo> TypeT unmarshallStructured(SdkPojo sdkPojo, SdkJsonNode jsonContent, JsonUnmarshallerContext context) {
        for (SdkField<?> field : sdkPojo.sdkFields()) {
            if (JsonProtocolUnmarshaller.isExplicitPayloadMember(field) && field.marshallingType() == MarshallingType.SDK_BYTES && context.response().content().isPresent()) {
                field.set(sdkPojo, SdkBytes.fromInputStream(context.response().content().get()));
                continue;
            }
            SdkJsonNode jsonFieldContent = JsonProtocolUnmarshaller.getSdkJsonNode(jsonContent, field);
            JsonUnmarshaller<Object> unmarshaller = context.getUnmarshaller(field.location(), field.marshallingType());
            field.set(sdkPojo, unmarshaller.unmarshall(context, jsonFieldContent, field));
        }
        return (TypeT)((SdkPojo)((Buildable)((Object)sdkPojo)).build());
    }

    private static SdkJsonNode getSdkJsonNode(SdkJsonNode jsonContent, SdkField<?> field) {
        if (jsonContent == null) {
            return null;
        }
        return JsonProtocolUnmarshaller.isExplicitPayloadMember(field) ? jsonContent : jsonContent.get(field.locationName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private JsonDomParser parser;
        private Map<MarshallLocation, TimestampFormatTrait.Format> defaultTimestampFormats;

        private Builder() {
        }

        public Builder parser(JsonDomParser parser) {
            this.parser = parser;
            return this;
        }

        public Builder defaultTimestampFormats(Map<MarshallLocation, TimestampFormatTrait.Format> formats) {
            this.defaultTimestampFormats = formats;
            return this;
        }

        public JsonProtocolUnmarshaller build() {
            return new JsonProtocolUnmarshaller(this);
        }
    }

    private static class SimpleTypeJsonUnmarshaller<T>
    implements JsonUnmarshaller<T> {
        private final StringToValueConverter.StringToValue<T> stringToValue;

        private SimpleTypeJsonUnmarshaller(StringToValueConverter.StringToValue<T> stringToValue) {
            this.stringToValue = stringToValue;
        }

        @Override
        public T unmarshall(JsonUnmarshallerContext context, SdkJsonNode jsonContent, SdkField<T> field) {
            return jsonContent != null && !jsonContent.isNull() ? (T)this.stringToValue.convert(jsonContent.asText(), field) : null;
        }
    }
}

