/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.cbor.internal;

import java.io.IOException;
import java.time.Instant;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.SdkJsonGenerator;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.StructuredJsonGenerator;

@SdkInternalApi
public final class SdkCborGenerator
extends SdkJsonGenerator {
    private static final int CBOR_TAG_TIMESTAMP = 1;

    SdkCborGenerator(JsonFactory factory, String contentType) {
        super(factory, contentType);
    }

    @Override
    public StructuredJsonGenerator writeValue(Instant instant) {
        if (!(this.getGenerator() instanceof CBORGenerator)) {
            throw new IllegalStateException("SdkCborGenerator is not created with a CBORGenerator.");
        }
        CBORGenerator generator = (CBORGenerator)this.getGenerator();
        try {
            generator.writeTag(1);
            generator.writeNumber(instant.toEpochMilli());
        }
        catch (IOException e) {
            throw new SdkJsonGenerator.JsonGenerationException(e);
        }
        return this;
    }
}

