/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal;

import java.util.Optional;
import org.apache.flink.kinesis.shaded.io.netty.channel.Channel;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http2.Http2Connection;
import org.apache.flink.kinesis.shaded.io.netty.handler.codec.http2.Http2Stream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.Http2Metric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.NoOpMetricCollector;

@SdkInternalApi
public class NettyRequestMetrics {
    private NettyRequestMetrics() {
    }

    public static boolean metricsAreEnabled(MetricCollector metricCollector) {
        return metricCollector != null && !(metricCollector instanceof NoOpMetricCollector);
    }

    public static void publishHttp2StreamMetrics(MetricCollector metricCollector, Channel channel) {
        if (!NettyRequestMetrics.metricsAreEnabled(metricCollector)) {
            return;
        }
        NettyRequestMetrics.getHttp2Connection(channel).ifPresent(http2Connection -> NettyRequestMetrics.writeHttp2RequestMetrics(metricCollector, channel, http2Connection));
    }

    private static Optional<Http2Connection> getHttp2Connection(Channel channel) {
        Channel parentChannel = channel.parent();
        if (parentChannel == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(parentChannel.attr(ChannelAttributeKey.HTTP2_CONNECTION).get());
    }

    private static void writeHttp2RequestMetrics(MetricCollector metricCollector, Channel channel, Http2Connection http2Connection) {
        int streamId = channel.attr(ChannelAttributeKey.HTTP2_FRAME_STREAM).get().id();
        Http2Stream stream = http2Connection.stream(streamId);
        metricCollector.reportMetric(Http2Metric.LOCAL_STREAM_WINDOW_SIZE_IN_BYTES, http2Connection.local().flowController().windowSize(stream));
        metricCollector.reportMetric(Http2Metric.REMOTE_STREAM_WINDOW_SIZE_IN_BYTES, http2Connection.remote().flowController().windowSize(stream));
    }
}

