/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.kinesis.shaded.io.netty.channel.Channel;
import org.apache.flink.kinesis.shaded.io.netty.handler.timeout.ReadTimeoutHandler;
import org.apache.flink.kinesis.shaded.io.netty.handler.timeout.WriteTimeoutHandler;
import org.apache.flink.kinesis.shaded.io.netty.util.concurrent.Future;
import org.apache.flink.kinesis.shaded.io.netty.util.concurrent.Promise;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.LastHttpContentHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.SdkChannelPool;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.http2.FlushOnReadHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.nrs.HttpStreamsClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.utils.ChannelUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public class HandlerRemovingChannelPool
implements SdkChannelPool {
    private final SdkChannelPool delegate;

    public HandlerRemovingChannelPool(SdkChannelPool delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<Channel> acquire() {
        return this.delegate.acquire();
    }

    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.delegate.acquire(promise);
    }

    @Override
    public Future<Void> release(Channel channel) {
        this.removePerRequestHandlers(channel);
        return this.delegate.release(channel);
    }

    @Override
    public Future<Void> release(Channel channel, Promise<Void> promise) {
        this.removePerRequestHandlers(channel);
        return this.delegate.release(channel, promise);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private void removePerRequestHandlers(Channel channel) {
        channel.attr(ChannelAttributeKey.IN_USE).set(false);
        if (channel.isOpen() || channel.isRegistered()) {
            ChannelUtils.removeIfExists(channel.pipeline(), HttpStreamsClientHandler.class, LastHttpContentHandler.class, FlushOnReadHandler.class, ResponseHandler.class, ReadTimeoutHandler.class, WriteTimeoutHandler.class);
        }
    }

    @Override
    public CompletableFuture<Void> collectChannelPoolMetrics(MetricCollector metrics) {
        return this.delegate.collectChannelPoolMetrics(metrics);
    }
}

