/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.apache.internal.conn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.flink.kinesis.shaded.org.apache.http.HttpHost;
import org.apache.flink.kinesis.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.flink.kinesis.shaded.org.apache.http.protocol.HttpContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.apache.internal.conn.TlsProtocol;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.apache.internal.net.SdkSocket;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.apache.internal.net.SdkSslSocket;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class SdkTlsSocketFactory
extends SSLConnectionSocketFactory {
    private static final Logger log = Logger.loggerFor(SdkTlsSocketFactory.class);
    private final SSLContext sslContext;

    public SdkTlsSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext must not be null. Use SSLContext.getDefault() if you are unsure.");
        }
        this.sslContext = sslContext;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void prepareSocket(SSLSocket socket) {
        String[] supported = socket.getSupportedProtocols();
        String[] enabled = socket.getEnabledProtocols();
        log.debug(() -> String.format("socket.getSupportedProtocols(): %s, socket.getEnabledProtocols(): %s", Arrays.toString(supported), Arrays.toString(enabled)));
        ArrayList<String> target = new ArrayList<String>();
        if (supported != null) {
            void var8_13;
            TlsProtocol[] tlsProtocolArray;
            TlsProtocol[] tlsProtocolArray2 = tlsProtocolArray = TlsProtocol.values();
            int n = tlsProtocolArray2.length;
            boolean bl = false;
            while (var8_13 < n) {
                TlsProtocol value = tlsProtocolArray2[var8_13];
                String pname = value.getProtocolName();
                if (this.existsIn(pname, supported)) {
                    target.add(pname);
                }
                ++var8_13;
            }
        }
        if (enabled != null) {
            for (String string : enabled) {
                if (target.contains(string)) continue;
                target.add(string);
            }
        }
        if (target.size() > 0) {
            String[] stringArray = target.toArray(new String[0]);
            socket.setEnabledProtocols(stringArray);
            log.debug(() -> "TLS protocol enabled for SSL handshake: " + Arrays.toString(enabling));
        }
    }

    private boolean existsIn(String element, String[] a) {
        for (String s : a) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        log.trace(() -> String.format("Connecting to %s:%s", remoteAddress.getAddress(), remoteAddress.getPort()));
        Socket connectedSocket = super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
        if (connectedSocket instanceof SSLSocket) {
            return new SdkSslSocket((SSLSocket)connectedSocket);
        }
        return new SdkSocket(connectedSocket);
    }
}

