/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.async;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.kinesis.shaded.org.reactivestreams.Publisher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.Response;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkStandardLogger;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpResponse;

@SdkInternalApi
public final class CombinedResponseAsyncHttpResponseHandler<OutputT>
implements TransformingAsyncResponseHandler<Response<OutputT>> {
    private final TransformingAsyncResponseHandler<OutputT> successResponseHandler;
    private final TransformingAsyncResponseHandler<? extends SdkException> errorResponseHandler;
    private CompletableFuture<SdkHttpResponse> headersFuture;
    private final AtomicReference<SdkHttpFullResponse> response = new AtomicReference();

    public CombinedResponseAsyncHttpResponseHandler(TransformingAsyncResponseHandler<OutputT> successResponseHandler, TransformingAsyncResponseHandler<? extends SdkException> errorResponseHandler) {
        this.successResponseHandler = successResponseHandler;
        this.errorResponseHandler = errorResponseHandler;
    }

    @Override
    public void onHeaders(SdkHttpResponse response) {
        this.headersFuture.complete(response);
        if (response.isSuccessful()) {
            SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Received successful response: " + response.statusCode());
            this.successResponseHandler.onHeaders(response);
        } else {
            SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Received error response: " + response.statusCode());
            this.errorResponseHandler.onHeaders(response);
        }
        this.response.set(CombinedResponseAsyncHttpResponseHandler.toFullResponse(response));
    }

    @Override
    public void onError(Throwable error) {
        if (this.headersFuture != null) {
            this.headersFuture.completeExceptionally(error);
        }
        this.successResponseHandler.onError(error);
    }

    @Override
    public void onStream(Publisher<ByteBuffer> publisher) {
        if (this.response.get().isSuccessful()) {
            this.successResponseHandler.onStream(publisher);
        } else {
            this.errorResponseHandler.onStream(publisher);
        }
    }

    @Override
    public CompletableFuture<Response<OutputT>> prepare() {
        this.response.set(null);
        CompletableFuture<OutputT> preparedTransformFuture = this.successResponseHandler.prepare();
        CompletableFuture<? extends SdkException> preparedErrorTransformFuture = this.errorResponseHandler == null ? null : this.errorResponseHandler.prepare();
        this.headersFuture = new CompletableFuture();
        return this.headersFuture.thenCompose(headers -> {
            if (headers.isSuccessful()) {
                return preparedTransformFuture.thenApply(r -> Response.builder().response(r).httpResponse(this.response.get()).isSuccess(true).build());
            }
            if (preparedErrorTransformFuture != null) {
                return preparedErrorTransformFuture.thenApply(e -> Response.builder().exception((SdkException)e).httpResponse(this.response.get()).isSuccess(false).build());
            }
            return CompletableFuture.completedFuture(Response.builder().httpResponse(this.response.get()).isSuccess(false).build());
        });
    }

    private static SdkHttpFullResponse toFullResponse(SdkHttpResponse response) {
        SdkHttpResponse.Builder builder = SdkHttpFullResponse.builder().statusCode(response.statusCode()).headers((Map)response.headers());
        response.statusText().ifPresent(((SdkHttpFullResponse.Builder)builder)::statusText);
        return builder.build();
    }
}

