/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.NotThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@NotThreadSafe
public class ExecutionAttributes
implements ToCopyableBuilder<Builder, ExecutionAttributes> {
    private final Map<ExecutionAttribute<?>, Object> attributes;

    public ExecutionAttributes() {
        this.attributes = new HashMap();
    }

    protected ExecutionAttributes(Map<? extends ExecutionAttribute<?>, ?> attributes) {
        this.attributes = new HashMap(attributes);
    }

    public <U> U getAttribute(ExecutionAttribute<U> attribute) {
        return (U)this.attributes.get(attribute);
    }

    public Map<ExecutionAttribute<?>, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public <U> ExecutionAttributes putAttribute(ExecutionAttribute<U> attribute, U value) {
        this.attributes.put(attribute, value);
        return this;
    }

    public ExecutionAttributes merge(ExecutionAttributes lowerPrecedenceExecutionAttributes) {
        HashMap copiedAttributes = new HashMap(this.attributes);
        lowerPrecedenceExecutionAttributes.getAttributes().forEach(copiedAttributes::putIfAbsent);
        return new ExecutionAttributes(copiedAttributes);
    }

    public <U> ExecutionAttributes putAttributeIfAbsent(ExecutionAttribute<U> attribute, U value) {
        this.attributes.putIfAbsent(attribute, value);
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return ExecutionAttributes.builder().putAll(this.attributes);
    }

    public ExecutionAttributes copy() {
        return this.toBuilder().build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionAttributes that = (ExecutionAttributes)o;
        return this.attributes != null ? this.attributes.equals(that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public static ExecutionAttributes unmodifiableExecutionAttributes(ExecutionAttributes attributes) {
        return new UnmodifiableExecutionAttributes(attributes);
    }

    public static final class Builder
    implements CopyableBuilder<Builder, ExecutionAttributes> {
        private final Map<ExecutionAttribute<?>, Object> executionAttributes = new HashMap();

        private Builder() {
        }

        public <T> Builder put(ExecutionAttribute<T> key, T value) {
            Validate.notNull(key, "Key to set must not be null.", new Object[0]);
            this.executionAttributes.put(key, value);
            return this;
        }

        public Builder putAll(Map<? extends ExecutionAttribute<?>, ?> attributes) {
            this.executionAttributes.putAll(attributes);
            return this;
        }

        @Override
        public ExecutionAttributes build() {
            return new ExecutionAttributes(this.executionAttributes);
        }
    }

    private static class UnmodifiableExecutionAttributes
    extends ExecutionAttributes {
        UnmodifiableExecutionAttributes(ExecutionAttributes executionAttributes) {
            super(executionAttributes.attributes);
        }

        @Override
        public <U> ExecutionAttributes putAttribute(ExecutionAttribute<U> attribute, U value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <U> ExecutionAttributes putAttributeIfAbsent(ExecutionAttribute<U> attribute, U value) {
            throw new UnsupportedOperationException();
        }
    }
}

