/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.CredentialUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.S3SignerExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.internal.AbstractAws4Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.internal.Aws4SignerRequestParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.internal.AwsChunkedEncodingInputStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.params.AwsS3V4SignerParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.ContentStreamProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.BinaryUtils;

@SdkPublicApi
public final class AwsS3V4Signer
extends AbstractAws4Signer<AwsS3V4SignerParams, Aws4PresignerParams> {
    private static final String CONTENT_SHA_256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    private static final String CONTENT_LENGTH = "Content-Length";

    private AwsS3V4Signer() {
    }

    public static AwsS3V4Signer create() {
        return new AwsS3V4Signer();
    }

    @Override
    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        AwsS3V4SignerParams signingParams = this.constructAwsS3SignerParams(executionAttributes);
        return this.sign(request, signingParams);
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, AwsS3V4SignerParams signingParams) {
        if (CredentialUtils.isAnonymous(signingParams.awsCredentials())) {
            return request;
        }
        Aws4SignerRequestParams requestParams = new Aws4SignerRequestParams(signingParams);
        return this.doSign(request, requestParams, signingParams).build();
    }

    private AwsS3V4SignerParams constructAwsS3SignerParams(ExecutionAttributes executionAttributes) {
        AwsS3V4SignerParams.Builder signerParams = this.extractSignerParams(AwsS3V4SignerParams.builder(), executionAttributes);
        Optional.ofNullable(executionAttributes.getAttribute(S3SignerExecutionAttribute.ENABLE_CHUNKED_ENCODING)).ifPresent(signerParams::enableChunkedEncoding);
        Optional.ofNullable(executionAttributes.getAttribute(S3SignerExecutionAttribute.ENABLE_PAYLOAD_SIGNING)).ifPresent(signerParams::enablePayloadSigning);
        return signerParams.build();
    }

    @Override
    public SdkHttpFullRequest presign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        Aws4PresignerParams signingParams = this.extractPresignerParams(Aws4PresignerParams.builder(), executionAttributes).build();
        return this.presign(request, signingParams);
    }

    public SdkHttpFullRequest presign(SdkHttpFullRequest request, Aws4PresignerParams signingParams) {
        if (CredentialUtils.isAnonymous(signingParams.awsCredentials())) {
            return request;
        }
        Aws4SignerRequestParams requestParams = new Aws4SignerRequestParams(signingParams);
        return this.doPresign(request, requestParams, signingParams).build();
    }

    @Override
    protected void processRequestPayload(SdkHttpFullRequest.Builder mutableRequest, byte[] signature, byte[] signingKey, Aws4SignerRequestParams signerRequestParams, AwsS3V4SignerParams signerParams) {
        if (this.useChunkEncoding(mutableRequest, signerParams) && mutableRequest.contentStreamProvider() != null) {
            ContentStreamProvider streamProvider = mutableRequest.contentStreamProvider();
            mutableRequest.contentStreamProvider(() -> this.asChunkEncodedStream(streamProvider.newStream(), signature, signingKey, signerRequestParams));
        }
    }

    @Override
    protected String calculateContentHashPresign(SdkHttpFullRequest.Builder mutableRequest, Aws4PresignerParams signerParams) {
        return UNSIGNED_PAYLOAD;
    }

    private AwsChunkedEncodingInputStream asChunkEncodedStream(InputStream inputStream, byte[] signature, byte[] signingKey, Aws4SignerRequestParams signerRequestParams) {
        return new AwsChunkedEncodingInputStream(inputStream, signingKey, signerRequestParams.getFormattedRequestSigningDateTime(), signerRequestParams.getScope(), BinaryUtils.toHex(signature), this);
    }

    @Override
    protected String calculateContentHash(SdkHttpFullRequest.Builder mutableRequest, AwsS3V4SignerParams signerParams) {
        mutableRequest.putHeader("x-amz-content-sha256", "required");
        if (this.isPayloadSigningEnabled(mutableRequest, signerParams)) {
            if (this.useChunkEncoding(mutableRequest, signerParams)) {
                long originalContentLength;
                String contentLength = mutableRequest.firstMatchingHeader(CONTENT_LENGTH).orElse(null);
                if (contentLength != null) {
                    originalContentLength = Long.parseLong(contentLength);
                } else {
                    try {
                        originalContentLength = AwsS3V4Signer.getContentLength(mutableRequest);
                    }
                    catch (IOException e) {
                        throw SdkClientException.builder().message("Cannot get the content-length of the request content.").cause(e).build();
                    }
                }
                mutableRequest.putHeader("x-amz-decoded-content-length", Long.toString(originalContentLength));
                mutableRequest.putHeader(CONTENT_LENGTH, Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength)));
                return CONTENT_SHA_256;
            }
            return super.calculateContentHash(mutableRequest, signerParams);
        }
        return UNSIGNED_PAYLOAD;
    }

    private boolean useChunkEncoding(SdkHttpFullRequest.Builder mutableRequest, AwsS3V4SignerParams signerParams) {
        return this.isPayloadSigningEnabled(mutableRequest, signerParams) && this.isChunkedEncodingEnabled(signerParams);
    }

    private boolean isChunkedEncodingEnabled(AwsS3V4SignerParams signerParams) {
        Boolean isChunkedEncodingEnabled = signerParams.enableChunkedEncoding();
        return isChunkedEncodingEnabled != null && isChunkedEncodingEnabled != false;
    }

    private boolean isPayloadSigningEnabled(SdkHttpFullRequest.Builder request, AwsS3V4SignerParams signerParams) {
        if (!request.protocol().equals("https") && request.contentStreamProvider() != null) {
            return true;
        }
        Boolean isPayloadSigningEnabled = signerParams.enablePayloadSigning();
        return isPayloadSigningEnabled != null && isPayloadSigningEnabled != false;
    }

    private static long getContentLength(SdkHttpFullRequest.Builder requestBuilder) throws IOException {
        int read;
        InputStream content = requestBuilder.contentStreamProvider().newStream();
        long contentLength = 0L;
        byte[] tmp = new byte[4096];
        while ((read = content.read(tmp)) != -1) {
            contentLength += (long)read;
        }
        return contentLength;
    }
}

